/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpHeaderAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import javax.annotation.Nullable;

public abstract class HttpCommonAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final CapturedHttpHeaders capturedHttpHeaders;

    HttpCommonAttributesExtractor(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
    }

    @Override
    public void onStart(AttributesBuilder attributes, REQUEST request) {
        this.set(attributes, SemanticAttributes.HTTP_METHOD, this.method(request));
        this.set(attributes, SemanticAttributes.HTTP_USER_AGENT, this.userAgent(request));
        for (String name : this.capturedHttpHeaders.requestHeaders()) {
            List<String> values = this.requestHeader(request, name);
            if (values.isEmpty()) continue;
            this.set(attributes, HttpHeaderAttributes.requestAttributeKey(name), values);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.set(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, this.requestContentLength(request, response));
        this.set(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED, this.requestContentLengthUncompressed(request, response));
        if (response != null) {
            Integer statusCode = this.statusCode(request, response);
            if (statusCode != null) {
                this.set(attributes, SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(statusCode.intValue()));
            }
            this.set(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, this.responseContentLength(request, response));
            this.set(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED, this.responseContentLengthUncompressed(request, response));
            for (String name : this.capturedHttpHeaders.responseHeaders()) {
                List<String> values = this.responseHeader(request, response, name);
                if (values.isEmpty()) continue;
                this.set(attributes, HttpHeaderAttributes.responseAttributeKey(name), values);
            }
        }
    }

    @Nullable
    protected abstract String method(REQUEST var1);

    @Nullable
    private String userAgent(REQUEST request) {
        return HttpCommonAttributesExtractor.firstHeaderValue(this.requestHeader(request, "user-agent"));
    }

    protected abstract List<String> requestHeader(REQUEST var1, String var2);

    @Nullable
    protected abstract Long requestContentLength(REQUEST var1, @Nullable RESPONSE var2);

    @Nullable
    protected abstract Long requestContentLengthUncompressed(REQUEST var1, @Nullable RESPONSE var2);

    @Nullable
    protected abstract Integer statusCode(REQUEST var1, RESPONSE var2);

    @Nullable
    protected abstract Long responseContentLength(REQUEST var1, RESPONSE var2);

    @Nullable
    protected abstract Long responseContentLengthUncompressed(REQUEST var1, RESPONSE var2);

    protected abstract List<String> responseHeader(REQUEST var1, RESPONSE var2, String var3);

    @Nullable
    static String firstHeaderValue(List<String> values) {
        return values.isEmpty() ? null : values.get(0);
    }
}

