/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.config.Config;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContextPropagationDebug {
    private static final Logger logger = LoggerFactory.getLogger(ContextPropagationDebug.class);
    private static final ContextKey<ContextPropagationDebug> THREAD_PROPAGATION_LOCATIONS = ContextKey.named((String)"thread-propagation-locations");
    private static final boolean THREAD_PROPAGATION_DEBUGGER = Config.get().getBoolean("otel.javaagent.experimental.thread-propagation-debugger.enabled", Config.get().isAgentDebugEnabled());
    private static final boolean FAIL_ON_CONTEXT_LEAK = Config.get().getBoolean("otel.javaagent.testing.fail-on-context-leak", false);
    private final Context sourceContext;
    private final List<Propagation> locations;
    private Context wrappedContext;

    private ContextPropagationDebug(Context sourceContext) {
        this.sourceContext = sourceContext;
        this.locations = new CopyOnWriteArrayList<Propagation>();
    }

    public static boolean isThreadPropagationDebuggerEnabled() {
        return THREAD_PROPAGATION_DEBUGGER;
    }

    public static Context appendLocations(Context context, StackTraceElement[] locations, Object carrier) {
        ContextPropagationDebug propagationDebug = ContextPropagationDebug.getPropagations(context);
        if (propagationDebug == null) {
            propagationDebug = new ContextPropagationDebug(context);
            propagationDebug.wrappedContext = context = context.with(THREAD_PROPAGATION_LOCATIONS, (Object)propagationDebug);
        }
        propagationDebug.locations.add(0, new Propagation(carrier.getClass().getName(), locations));
        return context;
    }

    public static void debugContextLeakIfEnabled() {
        if (!ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            return;
        }
        Context current = Context.current();
        if (current != Context.root()) {
            logger.error("Unexpected non-root current context found when extracting remote context!");
            Span currentSpan = Span.fromContextOrNull((Context)current);
            if (currentSpan != null) {
                logger.error("It contains this span: {}", (Object)currentSpan);
            }
            ContextPropagationDebug.debugContextPropagation(current);
            if (FAIL_ON_CONTEXT_LEAK) {
                throw new IllegalStateException("Context leak detected");
            }
        }
    }

    public static Context unwrap(Context context) {
        if (context == null || !ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            return context;
        }
        ContextPropagationDebug propagationDebug = ContextPropagationDebug.getPropagations(context);
        if (propagationDebug == null) {
            return context;
        }
        return propagationDebug.wrappedContext == context ? propagationDebug.sourceContext : context;
    }

    @Nullable
    private static ContextPropagationDebug getPropagations(Context context) {
        return (ContextPropagationDebug)context.get(THREAD_PROPAGATION_LOCATIONS);
    }

    private static void debugContextPropagation(Context context) {
        ContextPropagationDebug propagationDebug = ContextPropagationDebug.getPropagations(context);
        if (propagationDebug != null) {
            List<Propagation> propagations = propagationDebug.locations;
            StringBuilder sb = new StringBuilder();
            Iterator<Propagation> i = propagations.iterator();
            while (i.hasNext()) {
                Propagation entry = i.next();
                sb.append("\ncarrier of type: ").append(entry.carrierClassName);
                for (StackTraceElement ste : entry.location) {
                    sb.append("\n    ");
                    sb.append(ste);
                }
                if (!i.hasNext()) continue;
                sb.append("\nwhich was propagated from:");
            }
            logger.error("a context leak was detected. it was propagated from:{}", (Object)sb);
        }
    }

    private static class Propagation {
        public final String carrierClassName;
        public final StackTraceElement[] location;

        public Propagation(String carrierClassName, StackTraceElement[] location) {
            this.carrierClassName = carrierClassName;
            this.location = location;
        }
    }
}

