/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import javax.annotation.Nullable;

public class AppServerBridge {
    private static final ContextKey<AppServerBridge> CONTEXT_KEY = ContextKey.named((String)"opentelemetry-servlet-app-server-bridge");
    private final boolean servletShouldRecordException;
    private Throwable exception;

    public static Context init(Context ctx) {
        return AppServerBridge.init(ctx, true);
    }

    public static Context init(Context ctx, boolean shouldRecordException) {
        return ctx.with(CONTEXT_KEY, (Object)new AppServerBridge(shouldRecordException));
    }

    private AppServerBridge(boolean shouldRecordException) {
        this.servletShouldRecordException = shouldRecordException;
    }

    public static void recordException(Context context, Throwable exception) {
        AppServerBridge appServerBridge = (AppServerBridge)context.get(CONTEXT_KEY);
        if (appServerBridge != null && appServerBridge.servletShouldRecordException) {
            appServerBridge.exception = exception;
        }
    }

    @Nullable
    public static Throwable getException(Context context) {
        AppServerBridge appServerBridge = (AppServerBridge)context.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return appServerBridge.exception;
        }
        return null;
    }

    public static Class<?> getCallDepthKey() {
        class Key {
            Key() {
            }
        }
        return Key.class;
    }
}

