/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.httpclient;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.httpclient.JavaHttpClientTelemetryBuilder;
import io.opentelemetry.instrumentation.httpclient.internal.HttpHeadersSetter;
import io.opentelemetry.instrumentation.httpclient.internal.OpenTelemetryHttpClient;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public final class JavaHttpClientTelemetry {
    private final Instrumenter<HttpRequest, HttpResponse<?>> instrumenter;
    private final HttpHeadersSetter headersSetter;

    public static JavaHttpClientTelemetry create(OpenTelemetry openTelemetry) {
        return JavaHttpClientTelemetry.builder(openTelemetry).build();
    }

    public static JavaHttpClientTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new JavaHttpClientTelemetryBuilder(openTelemetry);
    }

    JavaHttpClientTelemetry(Instrumenter<HttpRequest, HttpResponse<?>> instrumenter, HttpHeadersSetter headersSetter) {
        this.instrumenter = instrumenter;
        this.headersSetter = headersSetter;
    }

    public HttpClient newHttpClient(HttpClient client) {
        return new OpenTelemetryHttpClient(client, this.instrumenter, this.headersSetter);
    }
}

