/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.httpclient;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.httpclient.JavaHttpClientTelemetry;
import io.opentelemetry.instrumentation.httpclient.internal.HttpHeadersSetter;
import io.opentelemetry.instrumentation.httpclient.internal.JavaHttpClientInstrumenterFactory;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class JavaHttpClientTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super HttpRequest, ? super HttpResponse<?>>> additionalExtractors = new ArrayList();
    private Consumer<HttpClientAttributesExtractorBuilder<HttpRequest, HttpResponse<?>>> extractorConfigurer = builder -> {};
    private Consumer<HttpSpanNameExtractorBuilder<HttpRequest>> spanNameExtractorConfigurer = builder -> {};
    private boolean emitExperimentalHttpClientMetrics = false;

    JavaHttpClientTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public JavaHttpClientTelemetryBuilder addAttributeExtractor(AttributesExtractor<? super HttpRequest, ? super HttpResponse<?>> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpClientTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedRequestHeaders(requestHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpClientTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setCapturedResponseHeaders(responseHeaders));
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpClientTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.extractorConfigurer = this.extractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        this.spanNameExtractorConfigurer = this.spanNameExtractorConfigurer.andThen(builder -> builder.setKnownMethods(knownMethods));
        return this;
    }

    @CanIgnoreReturnValue
    public JavaHttpClientTelemetryBuilder setEmitExperimentalHttpClientMetrics(boolean emitExperimentalHttpClientMetrics) {
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
        return this;
    }

    public JavaHttpClientTelemetry build() {
        Instrumenter<HttpRequest, HttpResponse<?>> instrumenter = JavaHttpClientInstrumenterFactory.createInstrumenter(this.openTelemetry, this.extractorConfigurer, this.spanNameExtractorConfigurer, this.additionalExtractors, this.emitExperimentalHttpClientMetrics);
        return new JavaHttpClientTelemetry(instrumenter, new HttpHeadersSetter(this.openTelemetry.getPropagators()));
    }
}

