/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.httpclient.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import java.net.http.HttpHeaders;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class HttpHeadersSetter {
    private final ContextPropagators contextPropagators;

    public HttpHeadersSetter(ContextPropagators contextPropagators) {
        this.contextPropagators = contextPropagators;
    }

    public HttpHeaders inject(HttpHeaders original) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>(original.map());
        this.contextPropagators.getTextMapPropagator().inject(Context.current(), headerMap, (carrier, key, value) -> {
            if (carrier != null) {
                carrier.put(key, Collections.singletonList(value));
            }
        });
        return HttpHeaders.of(headerMap, (s, s2) -> true);
    }
}

