/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.httpclient.internal;

import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import javax.annotation.Nullable;

public enum JavaHttpClientAttributesGetter implements HttpClientAttributesGetter<HttpRequest, HttpResponse<?>>
{
    INSTANCE;


    public String getHttpRequestMethod(HttpRequest httpRequest) {
        return httpRequest.method();
    }

    public String getUrlFull(HttpRequest httpRequest) {
        return httpRequest.uri().toString();
    }

    public List<String> getHttpRequestHeader(HttpRequest httpRequest, String name) {
        return httpRequest.headers().allValues(name);
    }

    public Integer getHttpResponseStatusCode(HttpRequest httpRequest, HttpResponse<?> httpResponse, @Nullable Throwable error) {
        return httpResponse.statusCode();
    }

    public List<String> getHttpResponseHeader(HttpRequest httpRequest, HttpResponse<?> httpResponse, String name) {
        return httpResponse.headers().allValues(name);
    }

    @Nullable
    public String getNetworkProtocolName(HttpRequest request, @Nullable HttpResponse<?> response) {
        return "http";
    }

    @Nullable
    public String getNetworkProtocolVersion(HttpRequest request, @Nullable HttpResponse<?> response) {
        HttpClient.Version version = response != null ? response.version() : (HttpClient.Version)request.version().orElse(null);
        if (version == null) {
            return null;
        }
        switch (version) {
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2: {
                return "2";
            }
        }
        return null;
    }

    @Nullable
    public String getServerAddress(HttpRequest request) {
        return request.uri().getHost();
    }

    public Integer getServerPort(HttpRequest request) {
        return request.uri().getPort();
    }
}

