/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.httpclient.internal;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.httpclient.internal.JavaHttpClientAttributesGetter;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.function.Consumer;

public final class JavaHttpClientInstrumenterFactory {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.java-http-client";

    public static Instrumenter<HttpRequest, HttpResponse<?>> createInstrumenter(OpenTelemetry openTelemetry, Consumer<HttpClientAttributesExtractorBuilder<HttpRequest, HttpResponse<?>>> extractorConfigurer, Consumer<HttpSpanNameExtractorBuilder<HttpRequest>> spanNameExtractorConfigurer, List<AttributesExtractor<? super HttpRequest, ? super HttpResponse<?>>> additionalExtractors, boolean emitExperimentalHttpClientMetrics) {
        JavaHttpClientAttributesGetter httpAttributesGetter = JavaHttpClientAttributesGetter.INSTANCE;
        HttpClientAttributesExtractorBuilder httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        extractorConfigurer.accept(httpAttributesExtractorBuilder);
        HttpSpanNameExtractorBuilder httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        spanNameExtractorConfigurer.accept((HttpSpanNameExtractorBuilder<HttpRequest>)httpSpanNameExtractorBuilder);
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)httpSpanNameExtractorBuilder.build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(httpAttributesExtractorBuilder.build()).addAttributesExtractors(additionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (emitExperimentalHttpClientMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private JavaHttpClientInstrumenterFactory() {
    }
}

