/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.httpclient.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.httpclient.internal.CompletableFutureWrapper;
import io.opentelemetry.instrumentation.httpclient.internal.HttpHeadersSetter;
import io.opentelemetry.instrumentation.httpclient.internal.HttpRequestWrapper;
import io.opentelemetry.instrumentation.httpclient.internal.ResponseConsumer;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public final class OpenTelemetryHttpClient
extends HttpClient {
    private final HttpClient client;
    private final Instrumenter<HttpRequest, HttpResponse<?>> instrumenter;
    private final HttpHeadersSetter headersSetter;

    public OpenTelemetryHttpClient(HttpClient client, Instrumenter<HttpRequest, HttpResponse<?>> instrumenter, HttpHeadersSetter headersSetter) {
        this.client = client;
        this.instrumenter = instrumenter;
        this.headersSetter = headersSetter;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return this.client.cookieHandler();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return this.client.connectTimeout();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.client.followRedirects();
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return this.client.proxy();
    }

    @Override
    public SSLContext sslContext() {
        return this.client.sslContext();
    }

    @Override
    public SSLParameters sslParameters() {
        return this.client.sslParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return this.client.authenticator();
    }

    @Override
    public HttpClient.Version version() {
        return this.client.version();
    }

    @Override
    public Optional<Executor> executor() {
        return this.client.executor();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        Context parentContext = Context.current();
        if (request == null || !this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return this.client.send(request, responseBodyHandler);
        }
        HttpResponse<T> response = null;
        Throwable error = null;
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignore = context.makeCurrent();){
            HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request, this.headersSetter.inject(request.headers()));
            response = this.client.send(requestWrapper, responseBodyHandler);
        }
        catch (Throwable throwable) {
            error = throwable;
            throw throwable;
        }
        finally {
            this.instrumenter.end(context, (Object)request, response, error);
        }
        return response;
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        return this.traceAsync(request, req -> this.client.sendAsync((HttpRequest)req, responseBodyHandler));
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return this.traceAsync(request, req -> this.client.sendAsync((HttpRequest)req, responseBodyHandler, pushPromiseHandler));
    }

    private <T> CompletableFuture<HttpResponse<T>> traceAsync(HttpRequest request, Function<HttpRequest, CompletableFuture<HttpResponse<T>>> action) {
        CompletionStage<HttpResponse<T>> completionStage;
        block9: {
            Context parentContext = Context.current();
            if (request == null || !this.instrumenter.shouldStart(parentContext, (Object)request)) {
                return action.apply(request);
            }
            Context context = this.instrumenter.start(parentContext, (Object)request);
            Scope ignore = context.makeCurrent();
            try {
                HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request, this.headersSetter.inject(request.headers()));
                CompletionStage<HttpResponse<T>> future = action.apply(requestWrapper);
                future = future.whenComplete((BiConsumer)new ResponseConsumer(this.instrumenter, context, request));
                completionStage = future = CompletableFutureWrapper.wrap(future, parentContext);
                if (ignore == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    this.instrumenter.end(context, (Object)request, null, throwable3);
                    throw throwable3;
                }
            }
            ignore.close();
        }
        return completionStage;
    }
}

