/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.instrumentation.jdbc.internal.DbInfo;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import java.util.WeakHashMap;

public final class JdbcData {
    private static final Map<DbInfo, WeakReference<DbInfo>> dbInfos = new WeakHashMap<DbInfo, WeakReference<DbInfo>>();
    public static final VirtualField<Connection, DbInfo> connectionInfo = VirtualField.find(Connection.class, DbInfo.class);
    public static final VirtualField<PreparedStatement, String> preparedStatement = VirtualField.find(PreparedStatement.class, String.class);

    private JdbcData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbInfo intern(DbInfo dbInfo) {
        Map<DbInfo, WeakReference<DbInfo>> map = dbInfos;
        synchronized (map) {
            DbInfo result;
            WeakReference<DbInfo> reference = dbInfos.get(dbInfo);
            if (reference != null && (result = (DbInfo)reference.get()) != null) {
                return result;
            }
            dbInfos.put(dbInfo, new WeakReference<DbInfo>(dbInfo));
            return dbInfo;
        }
    }
}

