/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcAttributesGetter;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcNetAttributesGetter;

public final class JdbcInstrumenterFactory {
    public static final String INSTRUMENTATION_NAME = "io.opentelemetry.jdbc";
    private static final JdbcAttributesGetter dbAttributesGetter = new JdbcAttributesGetter();
    private static final JdbcNetAttributesGetter netAttributesGetter = new JdbcNetAttributesGetter();

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter() {
        return JdbcInstrumenterFactory.createStatementInstrumenter(GlobalOpenTelemetry.get());
    }

    public static Instrumenter<DbRequest, Void> createStatementInstrumenter(OpenTelemetry openTelemetry) {
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)DbClientSpanNameExtractor.create((SqlClientAttributesGetter)dbAttributesGetter)).addAttributesExtractor(SqlClientAttributesExtractor.builder((SqlClientAttributesGetter)dbAttributesGetter).setStatementSanitizationEnabled(ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.common.db-statement-sanitizer.enabled", (boolean)true)).build()).addAttributesExtractor(NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private JdbcInstrumenterFactory() {
    }
}

