/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.datasource;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.jdbc.internal.DataSourceInstrumenterFactory;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcInstrumenterFactory;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcUtils;
import io.opentelemetry.instrumentation.jdbc.internal.OpenTelemetryConnection;
import io.opentelemetry.instrumentation.jdbc.internal.ThrowingSupplier;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OpenTelemetryDataSource
implements DataSource,
AutoCloseable {
    private final DataSource delegate;
    private final Instrumenter<DataSource, Void> dataSourceInstrumenter;
    private final Instrumenter<DbRequest, Void> statementInstrumenter;
    private volatile DbInfo cachedDbInfo;

    @Deprecated
    public OpenTelemetryDataSource(DataSource delegate) {
        this(delegate, GlobalOpenTelemetry.get());
    }

    public OpenTelemetryDataSource(DataSource delegate, OpenTelemetry openTelemetry) {
        this.delegate = delegate;
        this.dataSourceInstrumenter = DataSourceInstrumenterFactory.createDataSourceInstrumenter(openTelemetry);
        this.statementInstrumenter = JdbcInstrumenterFactory.createStatementInstrumenter(openTelemetry);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.wrapCall(this.delegate::getConnection);
        DbInfo dbInfo = this.getDbInfo(connection);
        return new OpenTelemetryConnection(connection, dbInfo, this.statementInstrumenter);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.wrapCall(() -> this.delegate.getConnection(username, password));
        DbInfo dbInfo = this.getDbInfo(connection);
        return new OpenTelemetryConnection(connection, dbInfo, this.statementInstrumenter);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public void close() throws Exception {
        if (this.delegate instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.delegate)).close();
        }
    }

    private <T, E extends SQLException> T wrapCall(ThrowingSupplier<T, E> callable) throws E {
        T result;
        Context parentContext = Context.current();
        if (!Span.fromContext((Context)parentContext).getSpanContext().isValid()) {
            return callable.call();
        }
        Context context = this.dataSourceInstrumenter.start(parentContext, (Object)this.delegate);
        try (Scope ignored = context.makeCurrent();){
            result = callable.call();
        }
        catch (Throwable t) {
            this.dataSourceInstrumenter.end(context, (Object)this.delegate, null, t);
            throw t;
        }
        this.dataSourceInstrumenter.end(context, (Object)this.delegate, null, null);
        return result;
    }

    private DbInfo getDbInfo(Connection connection) {
        if (this.cachedDbInfo == null) {
            this.cachedDbInfo = JdbcUtils.computeDbInfo(connection);
        }
        return this.cachedDbInfo;
    }
}

