/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.instrumentation.jmx.engine.AttributeInfo;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttributeExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class BeanAttributeExtractor
implements MetricAttributeExtractor {
    private static final Logger logger = Logger.getLogger(BeanAttributeExtractor.class.getName());
    private final String baseName;
    private final String[] nameChain;

    public static BeanAttributeExtractor fromName(String rawName) {
        List<String> segments = BeanAttributeExtractor.splitByDot(rawName);
        String baseName = segments.remove(0);
        if (segments.isEmpty()) {
            return new BeanAttributeExtractor(baseName, new String[0]);
        }
        return new BeanAttributeExtractor(baseName, segments.toArray(new String[segments.size()]));
    }

    private static List<String> splitByDot(String rawName) {
        ArrayList<String> components = new ArrayList<String>();
        try {
            StringBuilder currentSegment = new StringBuilder();
            boolean escaped = false;
            for (int i = 0; i < rawName.length(); ++i) {
                char ch = rawName.charAt(i);
                if (escaped) {
                    if (ch != '\\' && ch != '.') {
                        throw new IllegalArgumentException("Invalid escape sequence in attribute name '" + rawName + "'");
                    }
                    currentSegment.append(ch);
                    escaped = false;
                    continue;
                }
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                if (ch == '.') {
                    BeanAttributeExtractor.verifyAndAddNameSegment(components, currentSegment);
                    currentSegment = new StringBuilder();
                    continue;
                }
                currentSegment.append(ch);
            }
            BeanAttributeExtractor.verifyAndAddNameSegment(components, currentSegment);
        }
        catch (IllegalArgumentException unused) {
            throw new IllegalArgumentException("Invalid attribute name '" + rawName + "'");
        }
        return components;
    }

    private static void verifyAndAddNameSegment(List<String> segments, StringBuilder candidate) {
        String newSegment = candidate.toString().trim();
        if (newSegment.isEmpty()) {
            throw new IllegalArgumentException();
        }
        segments.add(newSegment);
    }

    public BeanAttributeExtractor(String baseName, String ... nameChain) {
        if (baseName == null || nameChain == null) {
            throw new IllegalArgumentException("null argument for BeanAttributeExtractor");
        }
        this.baseName = baseName;
        this.nameChain = nameChain;
    }

    public String getAttributeName() {
        if (this.nameChain.length > 0) {
            StringBuilder builder = new StringBuilder(this.baseName);
            for (String component : this.nameChain) {
                builder.append(".").append(component);
            }
            return builder.toString();
        }
        return this.baseName;
    }

    @Nullable
    AttributeInfo getAttributeInfo(MBeanServer server, ObjectName objectName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Resolving {0} for {1}", new Object[]{this.getAttributeName(), objectName});
        }
        try {
            MBeanAttributeInfo[] allAttributes;
            MBeanInfo info = server.getMBeanInfo(objectName);
            for (MBeanAttributeInfo attr : allAttributes = info.getAttributes()) {
                Level logLevel;
                if (!this.baseName.equals(attr.getName())) continue;
                String description = attr.getDescription();
                Object sampleValue = this.extractAttributeValue(server, objectName, logger);
                if (sampleValue instanceof Number) {
                    return new AttributeInfo((Number)sampleValue, description);
                }
                Level level = logLevel = sampleValue == null ? Level.FINE : Level.INFO;
                if (logger.isLoggable(logLevel)) {
                    logger.log(logLevel, "Unusable value {0} for attribute {1} and ObjectName {2}", new Object[]{sampleValue == null ? "NULL" : sampleValue.getClass().getName(), this.getAttributeName(), objectName});
                }
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cannot find attribute {0} for ObjectName {1}", new Object[]{this.baseName, objectName});
            }
        }
        catch (InstanceNotFoundException e) {
            logger.log(Level.INFO, "The MBeanServer does not find {0}", objectName);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception {0} while inspecting attributes for ObjectName {1}", new Object[]{e, objectName});
        }
        return null;
    }

    @Nullable
    private Object extractAttributeValue(MBeanServer server, ObjectName objectName, Logger logger) {
        try {
            Object value = server.getAttribute(objectName, this.baseName);
            for (int k = 0; k < this.nameChain.length; ++k) {
                if (value instanceof CompositeData) {
                    value = ((CompositeData)value).get(this.nameChain[k]);
                    continue;
                }
                if (value instanceof TabularData) {
                    value = ((TabularData)value).get(new String[]{this.nameChain[k]});
                    continue;
                }
                if (logger == null) break;
                logger.log(Level.FINE, "Encountered a value of {0} while extracting attribute {1} for ObjectName {2}; unable to extract metric value", new Object[]{value == null ? "NULL" : value.getClass().getName(), this.getAttributeName(), objectName});
                break;
            }
            return value;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.log(Level.FINE, "Encountered {0} while extracting attribute {1} for ObjectName {2}; unable to extract metric value", new Object[]{e, this.getAttributeName(), objectName});
            }
            return null;
        }
    }

    @Nullable
    private Object extractAttributeValue(MBeanServer server, ObjectName objectName) {
        return this.extractAttributeValue(server, objectName, null);
    }

    @Nullable
    Number extractNumericalAttribute(MBeanServer server, ObjectName objectName) {
        Object value = this.extractAttributeValue(server, objectName);
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    @Override
    @Nullable
    public String extractValue(MBeanServer server, ObjectName objectName) {
        return this.extractStringAttribute(server, objectName);
    }

    @Nullable
    private String extractStringAttribute(MBeanServer server, ObjectName objectName) {
        Object value = this.extractAttributeValue(server, objectName);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

