/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.instrumentation.jmx.engine.AttributeInfo;
import io.opentelemetry.instrumentation.jmx.engine.BeanGroup;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.engine.MetricDef;
import io.opentelemetry.instrumentation.jmx.engine.MetricExtractor;
import io.opentelemetry.instrumentation.jmx.engine.MetricRegistrar;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

class BeanFinder {
    private final MetricRegistrar registrar;
    private MetricConfiguration conf;
    private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
    private final long discoveryDelay;
    private final long maxDelay;
    private long delay = 1000L;

    BeanFinder(MetricRegistrar registrar, long discoveryDelay) {
        this.registrar = registrar;
        this.discoveryDelay = Math.max(1000L, discoveryDelay);
        this.maxDelay = Math.max(60000L, discoveryDelay);
    }

    void discoverBeans(MetricConfiguration conf) {
        this.conf = conf;
        if (!conf.isEmpty()) {
            ManagementFactory.getPlatformMBeanServer();
        }
        this.exec.schedule(new Runnable(){

            @Override
            public void run() {
                BeanFinder.this.refreshState();
                BeanFinder.this.delay = Math.min(BeanFinder.this.delay + BeanFinder.this.discoveryDelay, BeanFinder.this.maxDelay);
                BeanFinder.this.exec.schedule(this, BeanFinder.this.delay, TimeUnit.MILLISECONDS);
            }
        }, this.delay, TimeUnit.MILLISECONDS);
    }

    private void refreshState() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MetricDef metricDef : this.conf.getMetricDefs()) {
            this.resolveBeans(metricDef, servers);
        }
    }

    private void resolveBeans(MetricDef metricDef, List<MBeanServer> servers) {
        BeanGroup beans = metricDef.getBeanGroup();
        for (MBeanServer server : servers) {
            HashSet<ObjectName> allObjectNames = new HashSet<ObjectName>();
            for (ObjectName pattern : beans.getNamePatterns()) {
                Set<ObjectName> objectNames = server.queryNames(pattern, beans.getQueryExp());
                allObjectNames.addAll(objectNames);
            }
            if (allObjectNames.isEmpty()) continue;
            this.resolveAttributes(allObjectNames, server, metricDef);
            break;
        }
    }

    private void resolveAttributes(Set<ObjectName> objectNames, MBeanServer server, MetricDef metricDef) {
        for (MetricExtractor extractor : metricDef.getMetricExtractors()) {
            ArrayList<ObjectName> validObjectNames = new ArrayList<ObjectName>();
            AttributeInfo attributeInfo = null;
            for (ObjectName objectName : objectNames) {
                AttributeInfo attr = extractor.getMetricValueExtractor().getAttributeInfo(server, objectName);
                if (attr == null) continue;
                if (attributeInfo == null) {
                    attributeInfo = attr;
                } else {
                    attributeInfo.updateFrom(attr);
                }
                validObjectNames.add(objectName);
            }
            if (validObjectNames.isEmpty()) continue;
            this.registrar.enrollExtractor(server, validObjectNames, extractor, attributeInfo);
        }
    }
}

