/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.engine;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.jmx.engine.BeanFinder;
import io.opentelemetry.instrumentation.jmx.engine.MetricConfiguration;
import io.opentelemetry.instrumentation.jmx.engine.MetricRegistrar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JmxMetricInsight {
    private static final Logger logger = Logger.getLogger(JmxMetricInsight.class.getName());
    private static final String INSTRUMENTATION_SCOPE = "io.opentelemetry.jmx";
    private final OpenTelemetry openTelemetry;
    private final long discoveryDelay;

    public static JmxMetricInsight createService(OpenTelemetry ot, long discoveryDelay) {
        return new JmxMetricInsight(ot, discoveryDelay);
    }

    public static Logger getLogger() {
        return logger;
    }

    private JmxMetricInsight(OpenTelemetry openTelemetry, long discoveryDelay) {
        this.openTelemetry = openTelemetry;
        this.discoveryDelay = discoveryDelay;
    }

    public void start(MetricConfiguration conf) {
        if (conf.isEmpty()) {
            logger.log(Level.FINE, "Empty JMX configuration, no metrics will be collected for InstrumentationScope io.opentelemetry.jmx");
        } else {
            MetricRegistrar registrar = new MetricRegistrar(this.openTelemetry, INSTRUMENTATION_SCOPE);
            BeanFinder finder = new BeanFinder(registrar, this.discoveryDelay);
            finder.discoverBeans(conf);
        }
    }
}

