/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jmx.yaml;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.jmx.engine.BeanAttributeExtractor;
import io.opentelemetry.instrumentation.jmx.engine.BeanGroup;
import io.opentelemetry.instrumentation.jmx.engine.MetricAttribute;
import io.opentelemetry.instrumentation.jmx.engine.MetricDef;
import io.opentelemetry.instrumentation.jmx.engine.MetricExtractor;
import io.opentelemetry.instrumentation.jmx.engine.MetricInfo;
import io.opentelemetry.instrumentation.jmx.yaml.Metric;
import io.opentelemetry.instrumentation.jmx.yaml.MetricStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxRule
extends MetricStructure {
    @Nullable
    private String bean;
    private List<String> beans;
    @Nullable
    private String prefix;
    private Map<String, Metric> mapping;

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = JmxRule.validateBean(bean);
    }

    public List<String> getBeans() {
        return this.beans;
    }

    private static String validateBean(String name) {
        try {
            String trimmed = name.trim();
            new ObjectName(trimmed);
            return trimmed;
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("'" + name + "' is not a valid JMX object name", e);
        }
    }

    public void setBeans(List<String> beans) {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : beans) {
            list.add(JmxRule.validateBean(name));
        }
        this.beans = list;
    }

    public void setPrefix(String prefix) {
        this.prefix = this.validatePrefix(prefix.trim());
    }

    @CanIgnoreReturnValue
    private String validatePrefix(String prefix) {
        this.requireNonEmpty(prefix, "The metric name prefix is empty");
        return prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, Metric> getMapping() {
        return this.mapping;
    }

    public void setMapping(Map<String, Metric> mapping) {
        this.mapping = JmxRule.validateAttributeMapping(mapping);
    }

    @CanIgnoreReturnValue
    private static Map<String, Metric> validateAttributeMapping(Map<String, Metric> mapping) {
        if (mapping.isEmpty()) {
            throw new IllegalStateException("No MBean attributes specified");
        }
        Set<String> attrNames = mapping.keySet();
        for (String attributeName : attrNames) {
            BeanAttributeExtractor.fromName(attributeName);
        }
        return mapping;
    }

    public MetricDef buildMetricDef() throws Exception {
        BeanGroup group;
        if (this.bean != null) {
            group = new BeanGroup(null, new ObjectName(this.bean));
        } else if (this.beans != null && !this.beans.isEmpty()) {
            ObjectName[] objectNames = new ObjectName[this.beans.size()];
            int k = 0;
            for (String oneBean : this.beans) {
                objectNames[k++] = new ObjectName(oneBean);
            }
            group = new BeanGroup(null, objectNames);
        } else {
            throw new IllegalStateException("No ObjectName specified");
        }
        if (this.mapping == null || this.mapping.isEmpty()) {
            throw new IllegalStateException("No MBean attributes specified");
        }
        Set<String> attrNames = this.mapping.keySet();
        MetricExtractor[] metricExtractors = new MetricExtractor[attrNames.size()];
        int n = 0;
        for (String attributeName : attrNames) {
            BeanAttributeExtractor attrExtractor = BeanAttributeExtractor.fromName(attributeName);
            String niceAttributeName = attrExtractor.getAttributeName();
            Metric m = this.mapping.get(attributeName);
            MetricInfo metricInfo = m == null ? new MetricInfo(this.prefix == null ? niceAttributeName : this.prefix + niceAttributeName, null, this.getUnit(), this.getMetricType()) : m.buildMetricInfo(this.prefix, niceAttributeName, this.getUnit(), this.getMetricType());
            List<MetricAttribute> ownAttributes = this.getAttributeList();
            List<MetricAttribute> attributeList = ownAttributes != null && m != null && m.getAttributeList() != null ? JmxRule.combineMetricAttributes(ownAttributes, m.getAttributeList()) : (ownAttributes != null ? ownAttributes : (m != null && m.getAttributeList() != null ? m.getAttributeList() : new ArrayList<MetricAttribute>()));
            MetricExtractor metricExtractor = new MetricExtractor(attrExtractor, metricInfo, attributeList.toArray(new MetricAttribute[attributeList.size()]));
            metricExtractors[n++] = metricExtractor;
        }
        return new MetricDef(group, metricExtractors);
    }

    private static List<MetricAttribute> combineMetricAttributes(List<MetricAttribute> ownAttributes, List<MetricAttribute> metricAttributes) {
        HashMap<String, MetricAttribute> set = new HashMap<String, MetricAttribute>();
        for (MetricAttribute ownAttribute : ownAttributes) {
            set.put(ownAttribute.getAttributeName(), ownAttribute);
        }
        for (MetricAttribute metricAttribute : metricAttributes) {
            set.put(metricAttribute.getAttributeName(), metricAttribute);
        }
        return new ArrayList<MetricAttribute>(set.values());
    }
}

