/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.kafka.internal.KafkaInstrumenterFactory;
import io.opentelemetry.instrumentation.kafkaclients.KafkaTelemetry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public final class KafkaTelemetryBuilder {
    static final String INSTRUMENTATION_NAME = "io.opentelemetry.kafka-clients-2.6";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<ProducerRecord<?, ?>, RecordMetadata>> producerAttributesExtractors = new ArrayList();
    private final List<AttributesExtractor<ConsumerRecord<?, ?>, Void>> consumerAttributesExtractors = new ArrayList();
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes = false;
    private boolean propagationEnabled = true;

    KafkaTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry);
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addProducerAttributesExtractors(AttributesExtractor<ProducerRecord<?, ?>, RecordMetadata> extractor) {
        this.producerAttributesExtractors.add(extractor);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addConsumerAttributesExtractors(AttributesExtractor<ConsumerRecord<?, ?>, Void> extractor) {
        this.consumerAttributesExtractors.add(extractor);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setCapturedHeaders(List<String> capturedHeaders) {
        this.capturedHeaders = capturedHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setPropagationEnabled(boolean propagationEnabled) {
        this.propagationEnabled = propagationEnabled;
        return this;
    }

    public KafkaTelemetry build() {
        KafkaInstrumenterFactory instrumenterFactory = new KafkaInstrumenterFactory(this.openTelemetry, INSTRUMENTATION_NAME).setCapturedHeaders(this.capturedHeaders).setCaptureExperimentalSpanAttributes(this.captureExperimentalSpanAttributes);
        return new KafkaTelemetry(this.openTelemetry, instrumenterFactory.createProducerInstrumenter(this.producerAttributesExtractors), instrumenterFactory.createConsumerOperationInstrumenter(MessageOperation.RECEIVE, this.consumerAttributesExtractors), this.propagationEnabled);
    }
}

