/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.KafkaTelemetry;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class TracingConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    private static final KafkaTelemetry telemetry = KafkaTelemetry.create(GlobalOpenTelemetry.get());

    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        telemetry.buildAndFinishSpan(records);
        return records;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
    }
}

