/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class TracingConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    private static final KafkaTelemetry telemetry = KafkaTelemetry.create(GlobalOpenTelemetry.get());
    private String consumerGroup;
    private String clientId;

    @CanIgnoreReturnValue
    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        telemetry.buildAndFinishSpan(records, this.consumerGroup, this.clientId);
        return records;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.consumerGroup = Objects.toString(configs.get("group.id"), null);
        this.clientId = Objects.toString(configs.get("client.id"), null);
    }
}

