/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaInstrumenterFactory;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProducerRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaReceiveRequest;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.producer.RecordMetadata;

public final class KafkaTelemetryBuilder {
    static final String INSTRUMENTATION_NAME = "io.opentelemetry.kafka-clients-2.6";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<KafkaProducerRequest, RecordMetadata>> producerAttributesExtractors = new ArrayList<AttributesExtractor<KafkaProducerRequest, RecordMetadata>>();
    private final List<AttributesExtractor<KafkaProcessRequest, Void>> consumerProcessAttributesExtractors = new ArrayList<AttributesExtractor<KafkaProcessRequest, Void>>();
    private final List<AttributesExtractor<KafkaReceiveRequest, Void>> consumerReceiveAttributesExtractors = new ArrayList<AttributesExtractor<KafkaReceiveRequest, Void>>();
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes = false;
    private boolean propagationEnabled = true;
    private boolean messagingReceiveInstrumentationEnabled = false;

    KafkaTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry);
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addProducerAttributesExtractors(AttributesExtractor<KafkaProducerRequest, RecordMetadata> extractor) {
        this.producerAttributesExtractors.add(extractor);
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addConsumerAttributesExtractors(AttributesExtractor<KafkaProcessRequest, Void> extractor) {
        return this.addConsumerProcessAttributesExtractors(extractor);
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addConsumerProcessAttributesExtractors(AttributesExtractor<KafkaProcessRequest, Void> extractor) {
        this.consumerProcessAttributesExtractors.add(extractor);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addConsumerReceiveAttributesExtractors(AttributesExtractor<KafkaReceiveRequest, Void> extractor) {
        this.consumerReceiveAttributesExtractors.add(extractor);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setCapturedHeaders(Collection<String> capturedHeaders) {
        this.capturedHeaders = new ArrayList<String>(capturedHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setPropagationEnabled(boolean propagationEnabled) {
        this.propagationEnabled = propagationEnabled;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setMessagingReceiveInstrumentationEnabled(boolean messagingReceiveInstrumentationEnabled) {
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        return this;
    }

    public KafkaTelemetry build() {
        KafkaInstrumenterFactory instrumenterFactory = new KafkaInstrumenterFactory(this.openTelemetry, INSTRUMENTATION_NAME).setCapturedHeaders(this.capturedHeaders).setCaptureExperimentalSpanAttributes(this.captureExperimentalSpanAttributes).setMessagingReceiveInstrumentationEnabled(this.messagingReceiveInstrumentationEnabled);
        return new KafkaTelemetry(this.openTelemetry, (Instrumenter<KafkaProducerRequest, RecordMetadata>)instrumenterFactory.createProducerInstrumenter(this.producerAttributesExtractors), (Instrumenter<KafkaReceiveRequest, Void>)instrumenterFactory.createConsumerReceiveInstrumenter(this.consumerReceiveAttributesExtractors), (Instrumenter<KafkaProcessRequest, Void>)instrumenterFactory.createConsumerProcessInstrumenter(this.consumerProcessAttributesExtractors), this.propagationEnabled);
    }
}

