/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.instrumentation.api.internal.Timer;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContextUtil;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

@Deprecated
public class TracingConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    private static final KafkaTelemetry telemetry = KafkaTelemetry.builder(GlobalOpenTelemetry.get()).setMessagingReceiveInstrumentationEnabled(ConfigPropertiesUtil.getBoolean((String)"otel.instrumentation.messaging.experimental.receive-telemetry.enabled", (boolean)false)).setCapturedHeaders(ConfigPropertiesUtil.getList((String)"otel.instrumentation.messaging.experimental.capture-headers", Collections.emptyList())).build();
    private String consumerGroup;
    private String clientId;

    @CanIgnoreReturnValue
    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        Timer timer = Timer.start();
        Context receiveContext = telemetry.getConsumerTelemetry().buildAndFinishSpan(records, this.consumerGroup, this.clientId, timer);
        if (receiveContext == null) {
            receiveContext = Context.current();
        }
        KafkaConsumerContext consumerContext = KafkaConsumerContextUtil.create((Context)receiveContext, (String)this.consumerGroup, (String)this.clientId);
        return telemetry.getConsumerTelemetry().addTracing(records, consumerContext);
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.consumerGroup = Objects.toString(configs.get("group.id"), null);
        this.clientId = Objects.toString(configs.get("client.id"), null);
    }
}

