/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.internal.KafkaProducerTelemetry;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.internal.KafkaProducerTelemetrySupplier;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class OpenTelemetryProducerInterceptor<K, V>
implements ProducerInterceptor<K, V> {
    public static final String CONFIG_KEY_KAFKA_PRODUCER_TELEMETRY_SUPPLIER = "opentelemetry.kafka-producer-telemetry.supplier";
    @Nullable
    private KafkaProducerTelemetry producerTelemetry;
    @Nullable
    private String clientId;

    @CanIgnoreReturnValue
    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> producerRecord) {
        if (this.producerTelemetry != null) {
            this.producerTelemetry.buildAndInjectSpan(producerRecord, this.clientId);
        }
        return producerRecord;
    }

    public void onAcknowledgement(RecordMetadata recordMetadata, Exception e) {
    }

    public void close() {
    }

    public void configure(Map<String, ?> configs) {
        this.clientId = Objects.toString(configs.get("client.id"), null);
        KafkaProducerTelemetrySupplier supplier = OpenTelemetryProducerInterceptor.getProperty(configs, CONFIG_KEY_KAFKA_PRODUCER_TELEMETRY_SUPPLIER, KafkaProducerTelemetrySupplier.class);
        this.producerTelemetry = supplier.get();
    }

    private static <T> T getProperty(Map<String, ?> configs, String key, Class<T> requiredType) {
        Object value = configs.get(key);
        if (value == null) {
            throw new IllegalStateException("Missing required configuration property: " + key);
        }
        if (!requiredType.isInstance(value)) {
            throw new IllegalStateException("Configuration property " + key + " is not instance of " + requiredType.getSimpleName());
        }
        return requiredType.cast(value);
    }
}

