/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.TracingIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BooleanSupplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class TracingListIterator<K, V>
implements ListIterator<ConsumerRecord<K, V>> {
    private final ListIterator<ConsumerRecord<K, V>> delegateListIterator;
    private final Iterator<ConsumerRecord<K, V>> tracingIterator;

    private TracingListIterator(ListIterator<ConsumerRecord<K, V>> delegateListIterator, Instrumenter<KafkaProcessRequest, Void> instrumenter, BooleanSupplier wrappingEnabled, KafkaConsumerContext consumerContext) {
        this.delegateListIterator = delegateListIterator;
        this.tracingIterator = TracingIterator.wrap(delegateListIterator, instrumenter, wrappingEnabled, consumerContext);
    }

    public static <K, V> ListIterator<ConsumerRecord<K, V>> wrap(ListIterator<ConsumerRecord<K, V>> delegateListIterator, Instrumenter<KafkaProcessRequest, Void> instrumenter, BooleanSupplier wrappingEnabled, KafkaConsumerContext consumerContext) {
        if (wrappingEnabled.getAsBoolean()) {
            return new TracingListIterator<K, V>(delegateListIterator, instrumenter, wrappingEnabled, consumerContext);
        }
        return delegateListIterator;
    }

    @Override
    public boolean hasNext() {
        return this.tracingIterator.hasNext();
    }

    @Override
    public ConsumerRecord<K, V> next() {
        return this.tracingIterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.delegateListIterator.hasPrevious();
    }

    @Override
    public ConsumerRecord<K, V> previous() {
        return this.delegateListIterator.previous();
    }

    @Override
    public int nextIndex() {
        return this.delegateListIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.delegateListIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.delegateListIterator.remove();
    }

    @Override
    public void set(ConsumerRecord<K, V> consumerRecord) {
        this.delegateListIterator.set(consumerRecord);
    }

    @Override
    public void add(ConsumerRecord<K, V> consumerRecord) {
        this.delegateListIterator.add(consumerRecord);
    }
}

