/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.ReceivedRecords;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.common.TopicPartition;

public enum KafkaReceiveAttributesGetter implements MessagingAttributesGetter<ReceivedRecords, Void>
{
    INSTANCE;


    public String system(ReceivedRecords receivedRecords) {
        return "kafka";
    }

    public String destinationKind(ReceivedRecords receivedRecords) {
        return "topic";
    }

    @Nullable
    public String destination(ReceivedRecords receivedRecords) {
        Set topics = receivedRecords.records().partitions().stream().map(TopicPartition::topic).collect(Collectors.toSet());
        return topics.size() == 1 ? (String)topics.iterator().next() : null;
    }

    public boolean temporaryDestination(ReceivedRecords receivedRecords) {
        return false;
    }

    @Nullable
    public String protocol(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    public String protocolVersion(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    public String url(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    public String conversationId(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    public Long messagePayloadSize(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    public Long messagePayloadCompressedSize(ReceivedRecords receivedRecords) {
        return null;
    }

    @Nullable
    public String messageId(ReceivedRecords receivedRecords, @Nullable Void unused) {
        return null;
    }
}

