/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProcessRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

enum KafkaConsumerAttributesGetter implements MessagingAttributesGetter<KafkaProcessRequest, Void>
{
    INSTANCE;


    public String getSystem(KafkaProcessRequest request) {
        return "kafka";
    }

    public String getDestination(KafkaProcessRequest request) {
        return request.getRecord().topic();
    }

    public boolean isTemporaryDestination(KafkaProcessRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(KafkaProcessRequest request) {
        return null;
    }

    public Long getMessagePayloadSize(KafkaProcessRequest request) {
        return request.getRecord().serializedValueSize();
    }

    @Nullable
    public Long getMessagePayloadCompressedSize(KafkaProcessRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(KafkaProcessRequest request, @Nullable Void unused) {
        return null;
    }

    public List<String> getMessageHeader(KafkaProcessRequest request, String name) {
        return StreamSupport.stream(request.getRecord().headers().headers(name).spliterator(), false).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

