/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContext;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public final class KafkaConsumerContextUtil {
    private static final VirtualField<ConsumerRecord<?, ?>, Context> recordContextField = VirtualField.find(ConsumerRecord.class, Context.class);
    private static final VirtualField<ConsumerRecord<?, ?>, Consumer<?, ?>> recordConsumerField = VirtualField.find(ConsumerRecord.class, Consumer.class);
    private static final VirtualField<ConsumerRecords<?, ?>, Context> recordsContextField = VirtualField.find(ConsumerRecords.class, Context.class);
    private static final VirtualField<ConsumerRecords<?, ?>, Consumer<?, ?>> recordsConsumerField = VirtualField.find(ConsumerRecords.class, Consumer.class);

    public static KafkaConsumerContext get(ConsumerRecord<?, ?> records) {
        Context receiveContext = (Context)recordContextField.get(records);
        Consumer consumer = (Consumer)recordConsumerField.get(records);
        return KafkaConsumerContext.create(receiveContext, consumer);
    }

    public static KafkaConsumerContext get(ConsumerRecords<?, ?> records) {
        Context receiveContext = (Context)recordsContextField.get(records);
        Consumer consumer = (Consumer)recordsConsumerField.get(records);
        return KafkaConsumerContext.create(receiveContext, consumer);
    }

    public static void set(ConsumerRecord<?, ?> record, Context context, Consumer<?, ?> consumer) {
        recordContextField.set(record, (Object)context);
        recordConsumerField.set(record, consumer);
    }

    public static void set(ConsumerRecord<?, ?> record, KafkaConsumerContext consumerContext) {
        KafkaConsumerContextUtil.set(record, consumerContext.getContext(), consumerContext.getConsumer());
    }

    public static void set(ConsumerRecords<?, ?> records, Context context, Consumer<?, ?> consumer) {
        recordsContextField.set(records, (Object)context);
        recordsConsumerField.set(records, consumer);
    }

    public static void copy(ConsumerRecord<?, ?> from, ConsumerRecord<?, ?> to) {
        recordContextField.set(to, (Object)((Context)recordContextField.get(from)));
        recordConsumerField.set(to, (Object)((Consumer)recordConsumerField.get(from)));
    }

    private KafkaConsumerContextUtil() {
    }
}

