/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.instrumentation.kafka.internal.AbstractKafkaConsumerRequest;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerContext;
import io.opentelemetry.instrumentation.kafka.internal.KafkaUtil;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class KafkaProcessRequest
extends AbstractKafkaConsumerRequest {
    private final ConsumerRecord<?, ?> record;

    public static KafkaProcessRequest create(ConsumerRecord<?, ?> record, Consumer<?, ?> consumer) {
        return KafkaProcessRequest.create(record, KafkaUtil.getConsumerGroup(consumer), KafkaUtil.getClientId(consumer));
    }

    public static KafkaProcessRequest create(KafkaConsumerContext consumerContext, ConsumerRecord<?, ?> record) {
        return KafkaProcessRequest.create(record, consumerContext != null ? consumerContext.getConsumer() : null);
    }

    public static KafkaProcessRequest create(ConsumerRecord<?, ?> record, String consumerGroup, String clientId) {
        return new KafkaProcessRequest(record, consumerGroup, clientId);
    }

    public KafkaProcessRequest(ConsumerRecord<?, ?> record, String consumerGroup, String clientId) {
        super(consumerGroup, clientId);
        this.record = record;
    }

    public ConsumerRecord<?, ?> getRecord() {
        return this.record;
    }
}

