/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.lettuce.v5_1;

import io.lettuce.core.tracing.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.instrumentation.lettuce.v5_1.OpenTelemetryTracing;

public final class LettuceTelemetry {
    public static final String INSTRUMENTATION_NAME = "io.opentelemetry.lettuce-5.1";
    private final Tracer tracer;

    public static LettuceTelemetry create(OpenTelemetry openTelemetry) {
        return new LettuceTelemetry(openTelemetry);
    }

    private LettuceTelemetry(OpenTelemetry openTelemetry) {
        TracerBuilder tracerBuilder = openTelemetry.tracerBuilder(INSTRUMENTATION_NAME);
        String version = EmbeddedInstrumentationProperties.findVersion((String)INSTRUMENTATION_NAME);
        if (version != null) {
            tracerBuilder.setInstrumentationVersion(version);
        }
        this.tracer = tracerBuilder.build();
    }

    public Tracing newTracing() {
        return new OpenTelemetryTracing(this.tracer);
    }
}

