/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.appender.v2_16;

import io.opentelemetry.instrumentation.api.appender.internal.LogBuilder;
import io.opentelemetry.instrumentation.api.appender.internal.LogEmitterProvider;
import io.opentelemetry.instrumentation.api.appender.internal.LogEmitterProviderHolder;
import io.opentelemetry.instrumentation.log4j.appender.v2_16.internal.ContextDataAccessor;
import io.opentelemetry.instrumentation.log4j.appender.v2_16.internal.LogEventMapper;
import io.opentelemetry.instrumentation.sdk.appender.internal.DelegatingLogEmitterProvider;
import io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import java.io.Serializable;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="OpenTelemetry", category="Core", elementType="appender")
public class OpenTelemetryAppender
extends AbstractAppender {
    static final String PLUGIN_NAME = "OpenTelemetry";
    private static final LogEmitterProviderHolder logEmitterProviderHolder = new LogEmitterProviderHolder();
    private static final LogEventMapper<ReadOnlyStringMap> mapper = new LogEventMapper<ReadOnlyStringMap>(ContextDataAccessorImpl.INSTANCE);

    @PluginBuilderFactory
    public static <B extends Builder<B>> B builder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private OpenTelemetryAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
    }

    public void append(LogEvent event) {
        String instrumentationName = event.getLoggerName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogBuilder builder = logEmitterProviderHolder.get().logEmitterBuilder(instrumentationName).build().logBuilder();
        ReadOnlyStringMap contextData = event.getContextData();
        mapper.mapLogEvent(builder, event.getMessage(), event.getLevel(), event.getThrown(), event.getInstant(), contextData);
        builder.emit();
    }

    public static void setSdkLogEmitterProvider(SdkLogEmitterProvider sdkLogEmitterProvider) {
        logEmitterProviderHolder.set((LogEmitterProvider)DelegatingLogEmitterProvider.from((SdkLogEmitterProvider)sdkLogEmitterProvider));
    }

    public static void resetSdkLogEmitterProviderForTest() {
        logEmitterProviderHolder.resetForTest();
    }

    static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<OpenTelemetryAppender> {
        Builder() {
        }

        public OpenTelemetryAppender build() {
            return new OpenTelemetryAppender(this.getName(), this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray());
        }
    }

    private static enum ContextDataAccessorImpl implements ContextDataAccessor<ReadOnlyStringMap>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object getValue(ReadOnlyStringMap contextData, String key) {
            return contextData.getValue(key);
        }

        @Override
        public void forEach(ReadOnlyStringMap contextData, BiConsumer<String, Object> action) {
            contextData.forEach(action::accept);
        }
    }
}

