/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.appender.v2_16.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.appender.internal.LogBuilder;
import io.opentelemetry.instrumentation.api.appender.internal.Severity;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.instrumentation.log4j.appender.v2_16.internal.ContextDataAccessor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.Message;

public final class LogEventMapper<T> {
    private static final String SPECIAL_MAP_MESSAGE_ATTRIBUTE = "message";
    private static final boolean captureExperimentalAttributes = Config.get().getBoolean("otel.instrumentation.log4j-appender.experimental-log-attributes", false);
    private static final Cache<String, AttributeKey<String>> contextDataAttributeKeyCache = Cache.bounded((int)100);
    private static final Cache<String, AttributeKey<String>> mapMessageAttributeKeyCache = Cache.bounded((int)100);
    private final boolean captureMapMessageAttributes;
    private final List<String> captureContextDataAttributes;
    private final boolean captureAllContextDataAttributes;
    private final ContextDataAccessor<T> contextDataAccessor;

    public LogEventMapper(ContextDataAccessor<T> contextDataAccessor) {
        this(contextDataAccessor, Config.get().getBoolean("otel.instrumentation.log4j-appender.experimental.capture-map-message-attributes", false), Config.get().getList("otel.instrumentation.log4j-appender.experimental.capture-context-data-attributes", Collections.emptyList()));
    }

    LogEventMapper(ContextDataAccessor<T> contextDataAccessor, boolean captureMapMessageAttributes, List<String> captureContextDataAttributes) {
        this.contextDataAccessor = contextDataAccessor;
        this.captureMapMessageAttributes = captureMapMessageAttributes;
        this.captureContextDataAttributes = captureContextDataAttributes;
        this.captureAllContextDataAttributes = captureContextDataAttributes.size() == 1 && captureContextDataAttributes.get(0).equals("*");
    }

    public void mapLogEvent(LogBuilder builder, Message message, Level level, @Nullable Throwable throwable, @Nullable Instant timestamp, T contextData) {
        AttributesBuilder attributes = Attributes.builder();
        this.captureMessage(builder, attributes, message);
        if (level != null) {
            builder.setSeverity(LogEventMapper.levelToSeverity(level));
            builder.setSeverityText(level.name());
        }
        if (throwable != null) {
            LogEventMapper.setThrowable(attributes, throwable);
        }
        this.captureContextDataAttributes(attributes, contextData);
        if (captureExperimentalAttributes) {
            Thread currentThread = Thread.currentThread();
            attributes.put(SemanticAttributes.THREAD_NAME, (Object)currentThread.getName());
            attributes.put(SemanticAttributes.THREAD_ID, (Object)currentThread.getId());
        }
        builder.setAttributes(attributes.build());
        builder.setContext(Context.current());
        if (timestamp != null) {
            builder.setEpoch(TimeUnit.MILLISECONDS.toNanos(timestamp.getEpochMillisecond()) + (long)timestamp.getNanoOfMillisecond(), TimeUnit.NANOSECONDS);
        }
    }

    void captureMessage(LogBuilder builder, AttributesBuilder attributes, Message message) {
        boolean checkSpecialMapMessageAttribute;
        if (message == null) {
            return;
        }
        if (!(message instanceof MapMessage)) {
            builder.setBody(message.getFormattedMessage());
            return;
        }
        MapMessage mapMessage = (MapMessage)message;
        String body = mapMessage.getFormat();
        boolean bl = checkSpecialMapMessageAttribute = body == null || body.isEmpty();
        if (checkSpecialMapMessageAttribute) {
            body = mapMessage.get(SPECIAL_MAP_MESSAGE_ATTRIBUTE);
        }
        if (body != null && !body.isEmpty()) {
            builder.setBody(body);
        }
        if (this.captureMapMessageAttributes) {
            mapMessage.forEach((key, value) -> {
                if (!(value == null || checkSpecialMapMessageAttribute && key.equals(SPECIAL_MAP_MESSAGE_ATTRIBUTE))) {
                    attributes.put((AttributeKey)mapMessageAttributeKeyCache.computeIfAbsent(key, AttributeKey::stringKey), (Object)value.toString());
                }
            });
        }
    }

    void captureContextDataAttributes(AttributesBuilder attributes, T contextData) {
        if (this.captureAllContextDataAttributes) {
            this.contextDataAccessor.forEach(contextData, (key, value) -> {
                if (value != null) {
                    attributes.put(LogEventMapper.getContextDataAttributeKey(key), (Object)value.toString());
                }
            });
            return;
        }
        for (String key2 : this.captureContextDataAttributes) {
            Object value2 = this.contextDataAccessor.getValue(contextData, key2);
            if (value2 == null) continue;
            attributes.put(LogEventMapper.getContextDataAttributeKey(key2), (Object)value2.toString());
        }
    }

    public static AttributeKey<String> getContextDataAttributeKey(String key) {
        return (AttributeKey)contextDataAttributeKeyCache.computeIfAbsent((Object)key, k -> AttributeKey.stringKey((String)("log4j.context_data." + k)));
    }

    private static void setThrowable(AttributesBuilder attributes, Throwable throwable) {
        attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
        attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
    }

    private static Severity levelToSeverity(Level level) {
        switch (level.getStandardLevel()) {
            case ALL: 
            case TRACE: {
                return Severity.TRACE;
            }
            case DEBUG: {
                return Severity.DEBUG;
            }
            case INFO: {
                return Severity.INFO;
            }
            case WARN: {
                return Severity.WARN;
            }
            case ERROR: {
                return Severity.ERROR;
            }
            case FATAL: {
                return Severity.FATAL;
            }
            case OFF: {
                return Severity.UNDEFINED_SEVERITY_NUMBER;
            }
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }
}

