/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.v1_0;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.instrumentation.logback.v1_0.LoggingEventWrapper;
import io.opentelemetry.instrumentation.logback.v1_0.internal.UnionMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;

public class OpenTelemetryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();

    public static ILoggingEvent wrapEvent(ILoggingEvent event) {
        Span currentSpan = Span.current();
        if (!currentSpan.getSpanContext().isValid()) {
            return event;
        }
        AbstractMap eventContext = event.getMDCPropertyMap();
        if (eventContext != null && eventContext.containsKey("traceId")) {
            return event;
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        SpanContext spanContext = currentSpan.getSpanContext();
        contextData.put("traceId", spanContext.getTraceId());
        contextData.put("spanId", spanContext.getSpanId());
        contextData.put("sampled", Boolean.toString(spanContext.isSampled()));
        eventContext = eventContext == null ? contextData : new UnionMap(eventContext, contextData);
        return new LoggingEventWrapper(event, eventContext);
    }

    protected void append(ILoggingEvent event) {
        this.aai.appendLoopOnAppenders((Object)OpenTelemetryAppender.wrapEvent(event));
    }

    public void addAppender(Appender<ILoggingEvent> appender) {
        this.aai.addAppender(appender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }
}

