/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.v1_0.internal;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class UnionMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> first;
    private final Map<K, V> second;
    private int size = -1;
    private Set<Map.Entry<K, V>> entrySet;

    public UnionMap(Map<K, V> first, Map<K, V> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public int size() {
        Map<K, V> b;
        Map<K, V> a;
        if (this.size >= 0) {
            return this.size;
        }
        if (this.first.size() >= this.second.size()) {
            a = this.first;
            b = this.second;
        } else {
            a = this.second;
            b = this.first;
        }
        int size = a.size();
        if (!b.isEmpty()) {
            for (K k : b.keySet()) {
                if (a.containsKey(k)) continue;
                ++size;
            }
        }
        this.size = size;
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.first.containsKey(key) || this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.first.containsValue(value) || this.second.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V value = this.first.get(key);
        return value != null ? value : this.second.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> filteredSecond;
        if (this.entrySet != null) {
            return this.entrySet;
        }
        boolean secondHasDupes = false;
        for (Map.Entry<K, V> entry : this.second.entrySet()) {
            if (!this.first.containsKey(entry.getKey())) continue;
            secondHasDupes = true;
            break;
        }
        if (!secondHasDupes) {
            filteredSecond = this.second.entrySet();
        } else {
            filteredSecond = new LinkedHashSet<Map.Entry<K, V>>();
            for (Map.Entry<K, V> entry : this.second.entrySet()) {
                if (this.first.containsKey(entry.getKey())) continue;
                filteredSecond.add(entry);
            }
        }
        this.entrySet = Collections.unmodifiableSet(new ConcatenatedSet<Map.Entry<K, V>>(this.first.entrySet(), filteredSecond));
        return this.entrySet;
    }

    static final class ConcatenatedSet<T>
    extends AbstractSet<T> {
        private final Set<T> first;
        private final Set<T> second;
        private final int size;

        ConcatenatedSet(Set<T> first, Set<T> second) {
            this.first = first;
            this.second = second;
            this.size = first.size() + second.size();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return new ConcatenatedSetIterator();
        }

        class ConcatenatedSetIterator
        implements Iterator<T> {
            final Iterator<T> firstItr;
            final Iterator<T> secondItr;

            ConcatenatedSetIterator() {
                this.firstItr = ConcatenatedSet.this.first.iterator();
                this.secondItr = ConcatenatedSet.this.second.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.firstItr.hasNext() || this.secondItr.hasNext();
            }

            @Override
            public T next() {
                if (this.firstItr.hasNext()) {
                    return this.firstItr.next();
                }
                return this.secondItr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

