/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.appender.v1_0.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.appender.internal.LogEmitterProvider;
import io.opentelemetry.instrumentation.api.appender.internal.LogRecordBuilder;
import io.opentelemetry.instrumentation.api.appender.internal.Severity;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class LoggingEventMapper {
    private static final Cache<String, AttributeKey<String>> mdcAttributeKeys = Cache.bounded((int)100);
    private final boolean captureExperimentalAttributes;
    private final List<String> captureMdcAttributes;
    private final boolean captureAllMdcAttributes;
    private final boolean captureCodeAttributes;

    public LoggingEventMapper(boolean captureExperimentalAttributes, List<String> captureMdcAttributes, boolean captureCodeAttributes) {
        this.captureExperimentalAttributes = captureExperimentalAttributes;
        this.captureCodeAttributes = captureCodeAttributes;
        this.captureMdcAttributes = captureMdcAttributes;
        this.captureAllMdcAttributes = captureMdcAttributes.size() == 1 && captureMdcAttributes.get(0).equals("*");
    }

    public void emit(LogEmitterProvider logEmitterProvider, ILoggingEvent event) {
        String instrumentationName = event.getLoggerName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogRecordBuilder builder = logEmitterProvider.logEmitterBuilder(instrumentationName).build().logBuilder();
        this.mapLoggingEvent(builder, event);
        builder.emit();
    }

    private void mapLoggingEvent(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        StackTraceElement[] callerData;
        String message = loggingEvent.getFormattedMessage();
        if (message != null) {
            builder.setBody(message);
        }
        long timestamp = loggingEvent.getTimeStamp();
        builder.setEpoch(timestamp, TimeUnit.MILLISECONDS);
        Level level = loggingEvent.getLevel();
        if (level != null) {
            builder.setSeverity(LoggingEventMapper.levelToSeverity(level));
            builder.setSeverityText(level.levelStr);
        }
        AttributesBuilder attributes = Attributes.builder();
        IThrowableProxy throwableProxy = loggingEvent.getThrowableProxy();
        Throwable throwable = null;
        if (throwableProxy instanceof ThrowableProxy) {
            throwable = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        if (throwable != null) {
            LoggingEventMapper.setThrowable(attributes, throwable);
        }
        this.captureMdcAttributes(attributes, loggingEvent.getMDCPropertyMap());
        if (this.captureExperimentalAttributes) {
            Thread currentThread = Thread.currentThread();
            attributes.put(SemanticAttributes.THREAD_NAME, (Object)currentThread.getName());
            attributes.put(SemanticAttributes.THREAD_ID, (Object)currentThread.getId());
        }
        if (this.captureCodeAttributes && (callerData = loggingEvent.getCallerData()) != null && callerData.length > 0) {
            StackTraceElement firstStackElement = callerData[0];
            String fileName = firstStackElement.getFileName();
            if (fileName != null) {
                attributes.put(SemanticAttributes.CODE_FILEPATH, (Object)fileName);
            }
            attributes.put(SemanticAttributes.CODE_NAMESPACE, (Object)firstStackElement.getClassName());
            attributes.put(SemanticAttributes.CODE_FUNCTION, (Object)firstStackElement.getMethodName());
            int lineNumber = firstStackElement.getLineNumber();
            if (lineNumber > 0) {
                attributes.put(SemanticAttributes.CODE_LINENO, lineNumber);
            }
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    void captureMdcAttributes(AttributesBuilder attributes, Map<String, String> mdcProperties) {
        if (this.captureAllMdcAttributes) {
            for (Map.Entry<String, String> entry : mdcProperties.entrySet()) {
                attributes.put(LoggingEventMapper.getMdcAttributeKey(entry.getKey()), (Object)entry.getValue());
            }
            return;
        }
        for (String key : this.captureMdcAttributes) {
            String value = mdcProperties.get(key);
            if (value == null) continue;
            attributes.put(LoggingEventMapper.getMdcAttributeKey(key), (Object)value);
        }
    }

    public static AttributeKey<String> getMdcAttributeKey(String key) {
        return (AttributeKey)mdcAttributeKeys.computeIfAbsent((Object)key, k -> AttributeKey.stringKey((String)("logback.mdc." + k)));
    }

    private static void setThrowable(AttributesBuilder attributes, Throwable throwable) {
        attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
        attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
    }

    private static Severity levelToSeverity(Level level) {
        switch (level.levelInt) {
            case -2147483648: 
            case 5000: {
                return Severity.TRACE;
            }
            case 10000: {
                return Severity.DEBUG;
            }
            case 20000: {
                return Severity.INFO;
            }
            case 30000: {
                return Severity.WARN;
            }
            case 40000: {
                return Severity.ERROR;
            }
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }
}

