/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.appender.v1_0;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.opentelemetry.api.logs.GlobalLoggerProvider;
import io.opentelemetry.instrumentation.logback.appender.v1_0.internal.LoggingEventMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class OpenTelemetryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private boolean captureExperimentalAttributes = false;
    private boolean captureCodeAttributes = false;
    private boolean captureMarkerAttribute = false;
    private boolean captureKeyValuePairAttributes = false;
    private List<String> captureMdcAttributes = Collections.emptyList();
    private LoggingEventMapper mapper;

    public void start() {
        this.mapper = new LoggingEventMapper(this.captureExperimentalAttributes, this.captureMdcAttributes, this.captureCodeAttributes, this.captureMarkerAttribute, this.captureKeyValuePairAttributes);
        super.start();
    }

    protected void append(ILoggingEvent event) {
        this.mapper.emit(GlobalLoggerProvider.get(), event);
    }

    public void setCaptureExperimentalAttributes(boolean captureExperimentalAttributes) {
        this.captureExperimentalAttributes = captureExperimentalAttributes;
    }

    public void setCaptureCodeAttributes(boolean captureCodeAttributes) {
        this.captureCodeAttributes = captureCodeAttributes;
    }

    public void setCaptureMarkerAttribute(boolean captureMarkerAttribute) {
        this.captureMarkerAttribute = captureMarkerAttribute;
    }

    public void setCaptureKeyValuePairAttributes(boolean captureKeyValuePairAttributes) {
        this.captureKeyValuePairAttributes = captureKeyValuePairAttributes;
    }

    public void setCaptureMdcAttributes(String attributes) {
        this.captureMdcAttributes = attributes != null ? OpenTelemetryAppender.filterBlanksAndNulls(attributes.split(",")) : Collections.emptyList();
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

