/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.appender.v1_0.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.logstash.logback.marker.LogstashMarker;
import net.logstash.logback.marker.MapEntriesAppendingMarker;
import net.logstash.logback.marker.SingleFieldAppendingMarker;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public final class LoggingEventMapper {
    private static final AttributeKey<String> CODE_FILEPATH = AttributeKey.stringKey((String)"code.filepath");
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey((String)"code.function");
    private static final AttributeKey<Long> CODE_LINENO = AttributeKey.longKey((String)"code.lineno");
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey((String)"code.namespace");
    private static final AttributeKey<Long> THREAD_ID = AttributeKey.longKey((String)"thread.id");
    private static final AttributeKey<String> THREAD_NAME = AttributeKey.stringKey((String)"thread.name");
    private static final boolean supportsInstant = LoggingEventMapper.supportsInstant();
    private static final boolean supportsKeyValuePairs = LoggingEventMapper.supportsKeyValuePairs();
    private static final boolean supportsMultipleMarkers = LoggingEventMapper.supportsMultipleMarkers();
    private static final boolean supportsLogstashMarkers = LoggingEventMapper.supportsLogstashMarkers();
    private static final Cache<String, AttributeKey<String>> mdcAttributeKeys = Cache.bounded((int)100);
    private static final Cache<String, AttributeKey<String>> attributeKeys = Cache.bounded((int)100);
    private static final AttributeKey<List<String>> LOG_MARKER = AttributeKey.stringArrayKey((String)"logback.marker");
    private static final AttributeKey<String> LOG_BODY_TEMPLATE = AttributeKey.stringKey((String)"log.body.template");
    private static final AttributeKey<List<String>> LOG_BODY_PARAMETERS = AttributeKey.stringArrayKey((String)"log.body.parameters");
    private static final ClassValue<FieldReader> valueField = new ClassValue<FieldReader>(){

        @Override
        protected FieldReader computeValue(Class<?> type) {
            return LoggingEventMapper.createFieldReader(type);
        }
    };
    private final boolean captureExperimentalAttributes;
    private final List<String> captureMdcAttributes;
    private final boolean captureAllMdcAttributes;
    private final boolean captureCodeAttributes;
    private final boolean captureMarkerAttribute;
    private final boolean captureKeyValuePairAttributes;
    private final boolean captureLoggerContext;
    private final boolean captureArguments;
    private final boolean captureLogstashAttributes;

    private LoggingEventMapper(Builder builder) {
        this.captureExperimentalAttributes = builder.captureExperimentalAttributes;
        this.captureCodeAttributes = builder.captureCodeAttributes;
        this.captureMdcAttributes = builder.captureMdcAttributes;
        this.captureMarkerAttribute = builder.captureMarkerAttribute;
        this.captureKeyValuePairAttributes = builder.captureKeyValuePairAttributes;
        this.captureLoggerContext = builder.captureLoggerContext;
        this.captureArguments = builder.captureArguments;
        this.captureLogstashAttributes = builder.captureLogstashAttributes;
        this.captureAllMdcAttributes = builder.captureMdcAttributes.size() == 1 && ((String)builder.captureMdcAttributes.get(0)).equals("*");
    }

    public static Builder builder() {
        return new Builder();
    }

    public void emit(LoggerProvider loggerProvider, ILoggingEvent event, long threadId) {
        String instrumentationName = event.getLoggerName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogRecordBuilder builder = loggerProvider.loggerBuilder(instrumentationName).build().logRecordBuilder();
        this.mapLoggingEvent(builder, event, threadId);
        builder.emit();
    }

    private void mapLoggingEvent(LogRecordBuilder builder, ILoggingEvent loggingEvent, long threadId) {
        StackTraceElement[] callerData;
        String message = loggingEvent.getFormattedMessage();
        if (message != null) {
            builder.setBody(message);
        }
        if (supportsInstant && LoggingEventMapper.hasInstant(loggingEvent)) {
            LoggingEventMapper.setTimestampFromInstant(builder, loggingEvent);
        } else {
            long timestamp = loggingEvent.getTimeStamp();
            builder.setTimestamp(timestamp, TimeUnit.MILLISECONDS);
        }
        Level level = loggingEvent.getLevel();
        if (level != null) {
            builder.setSeverity(LoggingEventMapper.levelToSeverity(level));
            builder.setSeverityText(level.levelStr);
        }
        AttributesBuilder attributes = Attributes.builder();
        IThrowableProxy throwableProxy = loggingEvent.getThrowableProxy();
        Throwable throwable = null;
        if (throwableProxy instanceof ThrowableProxy) {
            throwable = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        if (throwable != null) {
            LoggingEventMapper.setThrowable(attributes, throwable);
        }
        this.captureMdcAttributes(attributes, loggingEvent.getMDCPropertyMap());
        if (this.captureExperimentalAttributes) {
            attributes.put(THREAD_NAME, (Object)loggingEvent.getThreadName());
            if (threadId != -1L) {
                attributes.put(THREAD_ID, (Object)threadId);
            }
        }
        if (this.captureCodeAttributes && (callerData = loggingEvent.getCallerData()) != null && callerData.length > 0) {
            StackTraceElement firstStackElement = callerData[0];
            String fileName = firstStackElement.getFileName();
            if (fileName != null) {
                attributes.put(CODE_FILEPATH, (Object)fileName);
            }
            attributes.put(CODE_NAMESPACE, (Object)firstStackElement.getClassName());
            attributes.put(CODE_FUNCTION, (Object)firstStackElement.getMethodName());
            int lineNumber = firstStackElement.getLineNumber();
            if (lineNumber > 0) {
                attributes.put(CODE_LINENO, lineNumber);
            }
        }
        if (this.captureMarkerAttribute) {
            boolean skipLogstashMarkers = supportsLogstashMarkers && this.captureLogstashAttributes;
            LoggingEventMapper.captureMarkerAttribute(attributes, loggingEvent, skipLogstashMarkers);
        }
        if (supportsKeyValuePairs && this.captureKeyValuePairAttributes) {
            LoggingEventMapper.captureKeyValuePairAttributes(attributes, loggingEvent);
        }
        if (this.captureLoggerContext) {
            LoggingEventMapper.captureLoggerContext(attributes, loggingEvent.getLoggerContextVO().getPropertyMap());
        }
        if (this.captureArguments && loggingEvent.getArgumentArray() != null && loggingEvent.getArgumentArray().length > 0) {
            this.captureArguments(attributes, loggingEvent.getMessage(), loggingEvent.getArgumentArray());
        }
        if (supportsLogstashMarkers && this.captureLogstashAttributes) {
            LoggingEventMapper.captureLogstashAttributes(attributes, loggingEvent);
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static boolean supportsInstant() {
        try {
            ILoggingEvent.class.getMethod("getInstant", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    @NoMuzzle
    private static boolean hasInstant(ILoggingEvent loggingEvent) {
        return loggingEvent.getInstant() != null;
    }

    @NoMuzzle
    private static void setTimestampFromInstant(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        builder.setTimestamp(loggingEvent.getInstant());
    }

    void captureMdcAttributes(AttributesBuilder attributes, Map<String, String> mdcProperties) {
        if (this.captureAllMdcAttributes) {
            for (Map.Entry<String, String> entry : mdcProperties.entrySet()) {
                attributes.put(LoggingEventMapper.getMdcAttributeKey(entry.getKey()), (Object)entry.getValue());
            }
            return;
        }
        for (String key : this.captureMdcAttributes) {
            String value = mdcProperties.get(key);
            if (value == null) continue;
            attributes.put(LoggingEventMapper.getMdcAttributeKey(key), (Object)value);
        }
    }

    void captureArguments(AttributesBuilder attributes, String message, Object[] arguments) {
        attributes.put(LOG_BODY_TEMPLATE, (Object)message);
        attributes.put(LOG_BODY_PARAMETERS, Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
    }

    public static AttributeKey<String> getMdcAttributeKey(String key) {
        return (AttributeKey)mdcAttributeKeys.computeIfAbsent((Object)key, AttributeKey::stringKey);
    }

    private static void setThrowable(AttributesBuilder attributes, Throwable throwable) {
        attributes.put(ExceptionAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
        attributes.put(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        attributes.put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
    }

    private static Severity levelToSeverity(Level level) {
        switch (level.levelInt) {
            case -2147483648: 
            case 5000: {
                return Severity.TRACE;
            }
            case 10000: {
                return Severity.DEBUG;
            }
            case 20000: {
                return Severity.INFO;
            }
            case 30000: {
                return Severity.WARN;
            }
            case 40000: {
                return Severity.ERROR;
            }
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }

    @NoMuzzle
    private static void captureKeyValuePairAttributes(AttributesBuilder attributes, ILoggingEvent loggingEvent) {
        List keyValuePairs = loggingEvent.getKeyValuePairs();
        if (keyValuePairs != null) {
            for (KeyValuePair keyValuePair : keyValuePairs) {
                LoggingEventMapper.captureAttribute(attributes, keyValuePair.key, keyValuePair.value);
            }
        }
    }

    static void captureAttribute(AttributesBuilder attributes, Object key, Object value) {
        if (key != null && value != null) {
            String keyStr = key.toString();
            if (value instanceof Boolean) {
                attributes.put(keyStr, ((Boolean)value).booleanValue());
            } else if (value instanceof Byte || value instanceof Integer || value instanceof Long || value instanceof Short) {
                attributes.put(keyStr, ((Number)value).longValue());
            } else if (value instanceof Double || value instanceof Float) {
                attributes.put(keyStr, ((Number)value).doubleValue());
            } else if (value.getClass().isArray()) {
                if (value instanceof boolean[] || value instanceof Boolean[]) {
                    LoggingEventMapper.captureArrayValueAttribute(attributes, AttributeKey.booleanArrayKey((String)keyStr), value, o -> (Boolean)o);
                } else if (value instanceof byte[] || value instanceof Byte[] || value instanceof int[] || value instanceof Integer[] || value instanceof long[] || value instanceof Long[] || value instanceof short[] || value instanceof Short[]) {
                    LoggingEventMapper.captureArrayValueAttribute(attributes, AttributeKey.longArrayKey((String)keyStr), value, o -> ((Number)o).longValue());
                } else if (value instanceof float[] || value instanceof Float[] || value instanceof double[] || value instanceof Double[]) {
                    LoggingEventMapper.captureArrayValueAttribute(attributes, AttributeKey.doubleArrayKey((String)keyStr), value, o -> ((Number)o).doubleValue());
                } else {
                    LoggingEventMapper.captureArrayValueAttribute(attributes, AttributeKey.stringArrayKey((String)keyStr), value, String::valueOf);
                }
            } else if (value instanceof Collection) {
                LoggingEventMapper.captureArrayValueAttribute(attributes, AttributeKey.stringArrayKey((String)keyStr), ((Collection)value).toArray(), String::valueOf);
            } else {
                attributes.put(LoggingEventMapper.getAttributeKey(keyStr), (Object)String.valueOf(value));
            }
        }
    }

    private static <T> void captureArrayValueAttribute(AttributesBuilder attributes, AttributeKey<List<T>> key, Object array, Function<Object, T> extractor) {
        ArrayList<T> list = new ArrayList<T>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            if (value == null) continue;
            list.add(extractor.apply(value));
        }
        if (!list.isEmpty()) {
            attributes.put(key, list);
        }
    }

    private static void captureLoggerContext(AttributesBuilder attributes, Map<String, String> loggerContextProperties) {
        for (Map.Entry<String, String> entry : loggerContextProperties.entrySet()) {
            attributes.put(LoggingEventMapper.getAttributeKey(entry.getKey()), (Object)entry.getValue());
        }
    }

    public static AttributeKey<String> getAttributeKey(String key) {
        return (AttributeKey)attributeKeys.computeIfAbsent((Object)key, AttributeKey::stringKey);
    }

    private static boolean supportsKeyValuePairs() {
        try {
            Class.forName("org.slf4j.event.KeyValuePair");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            ILoggingEvent.class.getMethod("getKeyValuePairs", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private static void captureMarkerAttribute(AttributesBuilder attributes, ILoggingEvent loggingEvent, boolean skipLogstashMarkers) {
        if (supportsMultipleMarkers && LoggingEventMapper.hasMultipleMarkers(loggingEvent)) {
            LoggingEventMapper.captureMultipleMarkerAttributes(attributes, loggingEvent, skipLogstashMarkers);
        } else {
            LoggingEventMapper.captureSingleMarkerAttribute(attributes, loggingEvent, skipLogstashMarkers);
        }
    }

    private static void captureSingleMarkerAttribute(AttributesBuilder attributes, ILoggingEvent loggingEvent, boolean skipLogstashMarkers) {
        Marker marker = loggingEvent.getMarker();
        if (!(marker == null || skipLogstashMarkers && LoggingEventMapper.isLogstashMarker(marker))) {
            attributes.put(LOG_MARKER, (Object[])new String[]{marker.getName()});
        }
    }

    @NoMuzzle
    private static void captureMultipleMarkerAttributes(AttributesBuilder attributes, ILoggingEvent loggingEvent, boolean skipLogstashMarkers) {
        ArrayList<String> markerNames = new ArrayList<String>(loggingEvent.getMarkerList().size());
        for (Marker marker : loggingEvent.getMarkerList()) {
            if (skipLogstashMarkers && LoggingEventMapper.isLogstashMarker(marker)) continue;
            markerNames.add(marker.getName());
        }
        if (!markerNames.isEmpty()) {
            attributes.put(LOG_MARKER, (Object[])markerNames.toArray(new String[0]));
        }
    }

    @NoMuzzle
    private static boolean hasMultipleMarkers(ILoggingEvent loggingEvent) {
        List markerList = loggingEvent.getMarkerList();
        return markerList != null && markerList.size() > 1;
    }

    private static boolean supportsMultipleMarkers() {
        try {
            ILoggingEvent.class.getMethod("getMarkerList", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private static void captureLogstashAttributes(AttributesBuilder attributes, ILoggingEvent loggingEvent) {
        if (supportsMultipleMarkers && LoggingEventMapper.hasMultipleMarkers(loggingEvent)) {
            LoggingEventMapper.captureMultipleLogstashAttributes(attributes, loggingEvent);
        } else {
            LoggingEventMapper.captureSingleLogstashAttribute(attributes, loggingEvent);
        }
    }

    @NoMuzzle
    private static boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }

    private static void captureSingleLogstashAttribute(AttributesBuilder attributes, ILoggingEvent loggingEvent) {
        Marker marker = loggingEvent.getMarker();
        if (LoggingEventMapper.isLogstashMarker(marker)) {
            LoggingEventMapper.captureLogstashMarker(attributes, marker);
        }
    }

    @NoMuzzle
    private static void captureMultipleLogstashAttributes(AttributesBuilder attributes, ILoggingEvent loggingEvent) {
        for (Marker marker : loggingEvent.getMarkerList()) {
            if (!LoggingEventMapper.isLogstashMarker(marker)) continue;
            LoggingEventMapper.captureLogstashMarker(attributes, marker);
        }
    }

    @NoMuzzle
    private static void captureLogstashMarker(AttributesBuilder attributes, Marker marker) {
        LogstashMarker logstashMarker = (LogstashMarker)marker;
        LoggingEventMapper.captureLogstashMarkerAttributes(attributes, logstashMarker);
        if (logstashMarker.hasReferences()) {
            for (Marker referenceMarker : logstashMarker) {
                if (!LoggingEventMapper.isLogstashMarker(referenceMarker)) continue;
                LoggingEventMapper.captureLogstashMarker(attributes, referenceMarker);
            }
        }
    }

    private static void captureLogstashMarkerAttributes(AttributesBuilder attributes, Object logstashMarker) {
        FieldReader fieldReader = valueField.get(logstashMarker.getClass());
        if (fieldReader != null) {
            fieldReader.read(attributes, logstashMarker);
        }
    }

    @NoMuzzle
    private static boolean isSingleFieldAppendingMarker(Class<?> type) {
        return SingleFieldAppendingMarker.class.isAssignableFrom(type);
    }

    @NoMuzzle
    private static boolean isMapEntriesAppendingMarker(Class<?> type) {
        return MapEntriesAppendingMarker.class.isAssignableFrom(type);
    }

    private static FieldReader createFieldReader(Class<?> type) {
        if (LoggingEventMapper.isSingleFieldAppendingMarker(type)) {
            return LoggingEventMapper.createStringReader(LoggingEventMapper.findValueField(type, "fieldValue", "object", "rawJson"));
        }
        if (LoggingEventMapper.isMapEntriesAppendingMarker(type)) {
            return LoggingEventMapper.createMapReader(LoggingEventMapper.findValueField(type, "map"));
        }
        return null;
    }

    @NoMuzzle
    private static String getSingleFieldAppendingMarkerName(Object logstashMarker) {
        SingleFieldAppendingMarker singleFieldAppendingMarker = (SingleFieldAppendingMarker)logstashMarker;
        return singleFieldAppendingMarker.getFieldName();
    }

    @Nullable
    private static FieldReader createStringReader(Field field) {
        if (field == null) {
            return null;
        }
        return (attributes, logstashMarker) -> {
            String fieldName = LoggingEventMapper.getSingleFieldAppendingMarkerName(logstashMarker);
            Object fieldValue = LoggingEventMapper.extractFieldValue(field, logstashMarker);
            LoggingEventMapper.captureAttribute(attributes, fieldName, fieldValue);
        };
    }

    @Nullable
    private static FieldReader createMapReader(Field field) {
        if (field == null) {
            return null;
        }
        return (attributes, logstashMarker) -> {
            Object fieldValue = LoggingEventMapper.extractFieldValue(field, logstashMarker);
            if (fieldValue instanceof Map) {
                Map map = (Map)fieldValue;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    LoggingEventMapper.captureAttribute(attributes, key, value);
                }
            }
        };
    }

    @Nullable
    private static Object extractFieldValue(Field field, Object logstashMarker) {
        try {
            return field.get(logstashMarker);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Nullable
    private static Field findValueField(Class<?> clazz, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return null;
    }

    private static boolean supportsLogstashMarkers() {
        try {
            Class.forName("net.logstash.logback.marker.LogstashMarker");
            Class.forName("net.logstash.logback.marker.SingleFieldAppendingMarker");
            Class.forName("net.logstash.logback.marker.MapEntriesAppendingMarker");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static final class Builder {
        private boolean captureExperimentalAttributes;
        private List<String> captureMdcAttributes = Collections.emptyList();
        private boolean captureCodeAttributes;
        private boolean captureMarkerAttribute;
        private boolean captureKeyValuePairAttributes;
        private boolean captureLoggerContext;
        private boolean captureArguments;
        private boolean captureLogstashAttributes;

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setCaptureExperimentalAttributes(boolean captureExperimentalAttributes) {
            this.captureExperimentalAttributes = captureExperimentalAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureMdcAttributes(List<String> captureMdcAttributes) {
            this.captureMdcAttributes = captureMdcAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureCodeAttributes(boolean captureCodeAttributes) {
            this.captureCodeAttributes = captureCodeAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureMarkerAttribute(boolean captureMarkerAttribute) {
            this.captureMarkerAttribute = captureMarkerAttribute;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureKeyValuePairAttributes(boolean captureKeyValuePairAttributes) {
            this.captureKeyValuePairAttributes = captureKeyValuePairAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureLoggerContext(boolean captureLoggerContext) {
            this.captureLoggerContext = captureLoggerContext;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureArguments(boolean captureArguments) {
            this.captureArguments = captureArguments;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureLogstashAttributes(boolean captureLogstashAttributes) {
            this.captureLogstashAttributes = captureLogstashAttributes;
            return this;
        }

        public LoggingEventMapper build() {
            return new LoggingEventMapper(this);
        }
    }

    private static interface FieldReader {
        public void read(AttributesBuilder var1, Object var2);
    }
}

