/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.appender.v1_0.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.tooling.muzzle.NoMuzzle;
import io.opentelemetry.semconv.CodeAttributes;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.logstash.logback.marker.LogstashMarker;
import net.logstash.logback.marker.MapEntriesAppendingMarker;
import net.logstash.logback.marker.SingleFieldAppendingMarker;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public final class LoggingEventMapper {
    private static final AttributeKey<String> CODE_FILEPATH = AttributeKey.stringKey((String)"code.filepath");
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey((String)"code.namespace");
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey((String)"code.function");
    private static final AttributeKey<Long> CODE_LINENO = AttributeKey.longKey((String)"code.lineno");
    private static final AttributeKey<Long> THREAD_ID = AttributeKey.longKey((String)"thread.id");
    private static final AttributeKey<String> THREAD_NAME = AttributeKey.stringKey((String)"thread.name");
    private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey((String)"event.name");
    private static final boolean supportsInstant = LoggingEventMapper.supportsInstant();
    private static final boolean supportsKeyValuePairs = LoggingEventMapper.supportsKeyValuePairs();
    private static final boolean supportsMultipleMarkers = LoggingEventMapper.supportsMultipleMarkers();
    private static final boolean supportsLogstashMarkers = LoggingEventMapper.supportsLogstashMarkers();
    private static final boolean supportsLogstashStructuredArguments = LoggingEventMapper.supportsLogstashStructuredArguments();
    private static final Cache<String, AttributeKey<String>> attributeKeys = Cache.bounded((int)100);
    private static final AttributeKey<List<String>> LOG_MARKER = AttributeKey.stringArrayKey((String)"logback.marker");
    private static final AttributeKey<String> LOG_BODY_TEMPLATE = AttributeKey.stringKey((String)"log.body.template");
    private static final AttributeKey<List<String>> LOG_BODY_PARAMETERS = AttributeKey.stringArrayKey((String)"log.body.parameters");
    private final boolean captureExperimentalAttributes;
    private final List<String> captureMdcAttributes;
    private final boolean captureAllMdcAttributes;
    private final boolean captureCodeAttributes;
    private final boolean captureMarkerAttribute;
    private final boolean captureKeyValuePairAttributes;
    private final boolean captureLoggerContext;
    private final boolean captureArguments;
    private final boolean captureLogstashMarkerAttributes;
    private final boolean captureLogstashStructuredArguments;
    private final boolean captureEventName;

    private LoggingEventMapper(Builder builder) {
        this.captureExperimentalAttributes = builder.captureExperimentalAttributes;
        this.captureCodeAttributes = builder.captureCodeAttributes;
        this.captureMdcAttributes = builder.captureMdcAttributes;
        this.captureMarkerAttribute = builder.captureMarkerAttribute;
        this.captureKeyValuePairAttributes = builder.captureKeyValuePairAttributes;
        this.captureLoggerContext = builder.captureLoggerContext;
        this.captureArguments = builder.captureArguments;
        this.captureLogstashMarkerAttributes = builder.captureLogstashMarkerAttributes;
        this.captureLogstashStructuredArguments = builder.captureLogstashStructuredArguments;
        this.captureAllMdcAttributes = builder.captureMdcAttributes.size() == 1 && ((String)builder.captureMdcAttributes.get(0)).equals("*");
        this.captureEventName = builder.captureEventName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void emit(LoggerProvider loggerProvider, ILoggingEvent event, long threadId) {
        String instrumentationName = event.getLoggerName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogRecordBuilder builder = loggerProvider.loggerBuilder(instrumentationName).build().logRecordBuilder();
        this.mapLoggingEvent(builder, event, threadId);
        builder.emit();
    }

    private void mapLoggingEvent(LogRecordBuilder builder, ILoggingEvent loggingEvent, long threadId) {
        StackTraceElement[] callerData;
        String message = loggingEvent.getFormattedMessage();
        if (message != null) {
            builder.setBody(message);
        }
        if (supportsInstant && LoggingEventMapper.hasInstant(loggingEvent)) {
            LoggingEventMapper.setTimestampFromInstant(builder, loggingEvent);
        } else {
            long timestamp = loggingEvent.getTimeStamp();
            builder.setTimestamp(timestamp, TimeUnit.MILLISECONDS);
        }
        Level level = loggingEvent.getLevel();
        if (level != null) {
            builder.setSeverity(LoggingEventMapper.levelToSeverity(level));
            builder.setSeverityText(level.levelStr);
        }
        IThrowableProxy throwableProxy = loggingEvent.getThrowableProxy();
        Throwable throwable = null;
        if (throwableProxy instanceof ThrowableProxy) {
            throwable = ((ThrowableProxy)throwableProxy).getThrowable();
        }
        if (throwable != null) {
            LoggingEventMapper.setThrowable(builder, throwable);
        }
        this.captureMdcAttributes(builder, loggingEvent.getMDCPropertyMap());
        if (this.captureExperimentalAttributes) {
            builder.setAttribute(THREAD_NAME, (Object)loggingEvent.getThreadName());
            if (threadId != -1L) {
                builder.setAttribute(THREAD_ID, (Object)threadId);
            }
        }
        if (this.captureCodeAttributes && (callerData = loggingEvent.getCallerData()) != null && callerData.length > 0) {
            StackTraceElement firstStackElement = callerData[0];
            String fileName = firstStackElement.getFileName();
            int lineNumber = firstStackElement.getLineNumber();
            if (SemconvStability.isEmitOldCodeSemconv()) {
                if (fileName != null) {
                    builder.setAttribute(CODE_FILEPATH, (Object)fileName);
                }
                builder.setAttribute(CODE_NAMESPACE, (Object)firstStackElement.getClassName());
                builder.setAttribute(CODE_FUNCTION, (Object)firstStackElement.getMethodName());
                if (lineNumber > 0) {
                    builder.setAttribute(CODE_LINENO, (Object)lineNumber);
                }
            }
            if (SemconvStability.isEmitStableCodeSemconv()) {
                if (fileName != null) {
                    builder.setAttribute(CodeAttributes.CODE_FILE_PATH, (Object)fileName);
                }
                builder.setAttribute(CodeAttributes.CODE_FUNCTION_NAME, (Object)(firstStackElement.getClassName() + "." + firstStackElement.getMethodName()));
                if (lineNumber > 0) {
                    builder.setAttribute(CodeAttributes.CODE_LINE_NUMBER, (Object)lineNumber);
                }
            }
        }
        if (this.captureMarkerAttribute) {
            boolean skipLogstashMarkers = supportsLogstashMarkers && this.captureLogstashMarkerAttributes;
            LoggingEventMapper.captureMarkerAttribute(builder, loggingEvent, skipLogstashMarkers);
        }
        if (supportsKeyValuePairs && this.captureKeyValuePairAttributes) {
            this.captureKeyValuePairAttributes(builder, loggingEvent);
        }
        if (supportsLogstashStructuredArguments && this.captureLogstashStructuredArguments && loggingEvent.getArgumentArray() != null && loggingEvent.getArgumentArray().length > 0) {
            this.captureLogstashStructuredArguments(builder, loggingEvent.getArgumentArray());
        }
        if (this.captureLoggerContext) {
            this.captureLoggerContext(builder, loggingEvent.getLoggerContextVO().getPropertyMap());
        }
        if (this.captureArguments && loggingEvent.getArgumentArray() != null && loggingEvent.getArgumentArray().length > 0) {
            this.captureArguments(builder, loggingEvent.getMessage(), loggingEvent.getArgumentArray());
        }
        if (supportsLogstashMarkers && this.captureLogstashMarkerAttributes) {
            this.captureLogstashMarkerAttributes(builder, loggingEvent);
        }
        builder.setContext(Context.current());
    }

    private static boolean supportsInstant() {
        try {
            ILoggingEvent.class.getMethod("getInstant", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    @NoMuzzle
    private static boolean hasInstant(ILoggingEvent loggingEvent) {
        return loggingEvent.getInstant() != null;
    }

    @NoMuzzle
    private static void setTimestampFromInstant(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        builder.setTimestamp(loggingEvent.getInstant());
    }

    void captureMdcAttributes(LogRecordBuilder builder, Map<String, String> mdcProperties) {
        if (this.captureAllMdcAttributes) {
            for (Map.Entry<String, String> entry : mdcProperties.entrySet()) {
                this.setAttributeOrEventName(builder, LoggingEventMapper.getAttributeKey(entry.getKey()), entry.getValue());
            }
            return;
        }
        for (String key : this.captureMdcAttributes) {
            String value = mdcProperties.get(key);
            this.setAttributeOrEventName(builder, LoggingEventMapper.getAttributeKey(key), value);
        }
    }

    void captureArguments(LogRecordBuilder builder, String message, Object[] arguments) {
        builder.setAttribute(LOG_BODY_TEMPLATE, (Object)message);
        builder.setAttribute(LOG_BODY_PARAMETERS, Arrays.stream(arguments).map(String::valueOf).collect(Collectors.toList()));
    }

    private static void setThrowable(LogRecordBuilder builder, Throwable throwable) {
        if (builder instanceof ExtendedLogRecordBuilder) {
            ((ExtendedLogRecordBuilder)builder).setException(throwable);
        } else {
            builder.setAttribute(ExceptionAttributes.EXCEPTION_TYPE, (Object)throwable.getClass().getName());
            builder.setAttribute(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)throwable.getMessage());
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            builder.setAttribute(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
        }
    }

    private static Severity levelToSeverity(Level level) {
        switch (level.levelInt) {
            case -2147483648: 
            case 5000: {
                return Severity.TRACE;
            }
            case 10000: {
                return Severity.DEBUG;
            }
            case 20000: {
                return Severity.INFO;
            }
            case 30000: {
                return Severity.WARN;
            }
            case 40000: {
                return Severity.ERROR;
            }
        }
        return Severity.UNDEFINED_SEVERITY_NUMBER;
    }

    @NoMuzzle
    private void captureKeyValuePairAttributes(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        List keyValuePairs = loggingEvent.getKeyValuePairs();
        if (keyValuePairs != null) {
            for (KeyValuePair keyValuePair : keyValuePairs) {
                LoggingEventMapper.captureAttribute(builder, this.captureEventName, keyValuePair.key, keyValuePair.value);
            }
        }
    }

    static void captureAttribute(LogRecordBuilder builder, boolean captureEventName, Object key, Object value) {
        if (key != null && value != null) {
            String keyStr = key.toString();
            if (value instanceof Boolean) {
                builder.setAttribute(keyStr, ((Boolean)value).booleanValue());
            } else if (value instanceof Byte || value instanceof Integer || value instanceof Long || value instanceof Short) {
                builder.setAttribute(keyStr, ((Number)value).longValue());
            } else if (value instanceof Double || value instanceof Float) {
                builder.setAttribute(keyStr, ((Number)value).doubleValue());
            } else if (value.getClass().isArray()) {
                if (value instanceof boolean[] || value instanceof Boolean[]) {
                    LoggingEventMapper.captureArrayValueAttribute(builder, AttributeKey.booleanArrayKey((String)keyStr), value, o -> (Boolean)o);
                } else if (value instanceof byte[] || value instanceof Byte[] || value instanceof int[] || value instanceof Integer[] || value instanceof long[] || value instanceof Long[] || value instanceof short[] || value instanceof Short[]) {
                    LoggingEventMapper.captureArrayValueAttribute(builder, AttributeKey.longArrayKey((String)keyStr), value, o -> ((Number)o).longValue());
                } else if (value instanceof float[] || value instanceof Float[] || value instanceof double[] || value instanceof Double[]) {
                    LoggingEventMapper.captureArrayValueAttribute(builder, AttributeKey.doubleArrayKey((String)keyStr), value, o -> ((Number)o).doubleValue());
                } else {
                    LoggingEventMapper.captureArrayValueAttribute(builder, AttributeKey.stringArrayKey((String)keyStr), value, String::valueOf);
                }
            } else if (value instanceof Collection) {
                LoggingEventMapper.captureArrayValueAttribute(builder, AttributeKey.stringArrayKey((String)keyStr), ((Collection)value).toArray(), String::valueOf);
            } else {
                LoggingEventMapper.setAttributeOrEventName(builder, captureEventName, LoggingEventMapper.getAttributeKey(keyStr), value);
            }
        }
    }

    private void setAttributeOrEventName(LogRecordBuilder builder, AttributeKey<String> key, Object value) {
        LoggingEventMapper.setAttributeOrEventName(builder, this.captureEventName, key, value);
    }

    private static void setAttributeOrEventName(LogRecordBuilder builder, boolean captureEventName, AttributeKey<String> key, Object value) {
        if (value != null) {
            if (captureEventName && key.equals(EVENT_NAME)) {
                builder.setEventName(value.toString());
            } else {
                builder.setAttribute(key, (Object)value.toString());
            }
        }
    }

    private static <T> void captureArrayValueAttribute(LogRecordBuilder builder, AttributeKey<List<T>> key, Object array, Function<Object, T> extractor) {
        ArrayList<T> list = new ArrayList<T>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(array, i);
            if (value == null) continue;
            list.add(extractor.apply(value));
        }
        if (!list.isEmpty()) {
            builder.setAttribute(key, list);
        }
    }

    private void captureLoggerContext(LogRecordBuilder builder, Map<String, String> loggerContextProperties) {
        for (Map.Entry<String, String> entry : loggerContextProperties.entrySet()) {
            this.setAttributeOrEventName(builder, LoggingEventMapper.getAttributeKey(entry.getKey()), entry.getValue());
        }
    }

    public static AttributeKey<String> getAttributeKey(String key) {
        return (AttributeKey)attributeKeys.computeIfAbsent((Object)key, AttributeKey::stringKey);
    }

    private static boolean supportsKeyValuePairs() {
        try {
            Class.forName("org.slf4j.event.KeyValuePair");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            ILoggingEvent.class.getMethod("getKeyValuePairs", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private static void captureMarkerAttribute(LogRecordBuilder builder, ILoggingEvent loggingEvent, boolean skipLogstashMarkers) {
        if (supportsMultipleMarkers && LoggingEventMapper.hasMultipleMarkers(loggingEvent)) {
            LoggingEventMapper.captureMultipleMarkerAttributes(builder, loggingEvent, skipLogstashMarkers);
        } else {
            LoggingEventMapper.captureSingleMarkerAttribute(builder, loggingEvent, skipLogstashMarkers);
        }
    }

    private static void captureSingleMarkerAttribute(LogRecordBuilder builder, ILoggingEvent loggingEvent, boolean skipLogstashMarkers) {
        Marker marker = loggingEvent.getMarker();
        if (!(marker == null || skipLogstashMarkers && LoggingEventMapper.isLogstashMarker(marker))) {
            builder.setAttribute(LOG_MARKER, Collections.singletonList(marker.getName()));
        }
    }

    @NoMuzzle
    private static void captureMultipleMarkerAttributes(LogRecordBuilder builder, ILoggingEvent loggingEvent, boolean skipLogstashMarkers) {
        ArrayList<String> markerNames = new ArrayList<String>(loggingEvent.getMarkerList().size());
        for (Marker marker : loggingEvent.getMarkerList()) {
            if (skipLogstashMarkers && LoggingEventMapper.isLogstashMarker(marker)) continue;
            markerNames.add(marker.getName());
        }
        if (!markerNames.isEmpty()) {
            builder.setAttribute(LOG_MARKER, markerNames);
        }
    }

    @NoMuzzle
    private static boolean hasMultipleMarkers(ILoggingEvent loggingEvent) {
        List markerList = loggingEvent.getMarkerList();
        return markerList != null && markerList.size() > 1;
    }

    private static boolean supportsMultipleMarkers() {
        try {
            ILoggingEvent.class.getMethod("getMarkerList", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private void captureLogstashMarkerAttributes(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        if (supportsMultipleMarkers && LoggingEventMapper.hasMultipleMarkers(loggingEvent)) {
            this.captureMultipleLogstashMarkers(builder, loggingEvent);
        } else {
            this.captureSingleLogstashMarker(builder, loggingEvent);
        }
    }

    @NoMuzzle
    private static boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }

    private void captureSingleLogstashMarker(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        Marker marker = loggingEvent.getMarker();
        if (LoggingEventMapper.isLogstashMarker(marker)) {
            this.captureLogstashMarkerAndReferences(builder, marker);
        }
    }

    @NoMuzzle
    private void captureMultipleLogstashMarkers(LogRecordBuilder builder, ILoggingEvent loggingEvent) {
        for (Marker marker : loggingEvent.getMarkerList()) {
            if (!LoggingEventMapper.isLogstashMarker(marker)) continue;
            this.captureLogstashMarkerAndReferences(builder, marker);
        }
    }

    @NoMuzzle
    private void captureLogstashMarkerAndReferences(LogRecordBuilder builder, Marker marker) {
        LogstashMarker logstashMarker = (LogstashMarker)marker;
        this.captureLogstashMarker(builder, logstashMarker);
        if (logstashMarker.hasReferences()) {
            for (Marker referenceMarker : logstashMarker) {
                if (!LoggingEventMapper.isLogstashMarker(referenceMarker)) continue;
                this.captureLogstashMarkerAndReferences(builder, referenceMarker);
            }
        }
    }

    private void captureLogstashMarker(LogRecordBuilder builder, Object logstashMarker) {
        FieldReader fieldReader = LogstashFieldReaderHolder.valueField.get(logstashMarker.getClass());
        if (fieldReader != null) {
            fieldReader.read(builder, logstashMarker, this.captureEventName);
        }
    }

    @NoMuzzle
    private static boolean isSingleFieldAppendingMarker(Class<?> type) {
        return SingleFieldAppendingMarker.class.isAssignableFrom(type);
    }

    @NoMuzzle
    private static boolean isMapEntriesAppendingMarker(Class<?> type) {
        return MapEntriesAppendingMarker.class.isAssignableFrom(type);
    }

    private static FieldReader createFieldReader(Class<?> type) {
        if (LoggingEventMapper.isSingleFieldAppendingMarker(type)) {
            return LoggingEventMapper.createStringReader(LoggingEventMapper.findValueField(type, "fieldValue", "object", "rawJson"));
        }
        if (LoggingEventMapper.isMapEntriesAppendingMarker(type)) {
            return LoggingEventMapper.createMapReader(LoggingEventMapper.findValueField(type, "map"));
        }
        return null;
    }

    @NoMuzzle
    private static String getSingleFieldAppendingMarkerName(Object logstashMarker) {
        SingleFieldAppendingMarker singleFieldAppendingMarker = (SingleFieldAppendingMarker)logstashMarker;
        return singleFieldAppendingMarker.getFieldName();
    }

    @Nullable
    private static FieldReader createStringReader(Field field) {
        if (field == null) {
            return null;
        }
        return (builder, logstashMarker, captureEventName) -> {
            String fieldName = LoggingEventMapper.getSingleFieldAppendingMarkerName(logstashMarker);
            Object fieldValue = LoggingEventMapper.extractFieldValue(field, logstashMarker);
            LoggingEventMapper.captureAttribute(builder, captureEventName, fieldName, fieldValue);
        };
    }

    @Nullable
    private static FieldReader createMapReader(Field field) {
        if (field == null) {
            return null;
        }
        return (attributes, logstashMarker, captureEventName) -> {
            Object fieldValue = LoggingEventMapper.extractFieldValue(field, logstashMarker);
            if (fieldValue instanceof Map) {
                Map map = (Map)fieldValue;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    LoggingEventMapper.captureAttribute(attributes, captureEventName, key, value);
                }
            }
        };
    }

    @Nullable
    private static Object extractFieldValue(Field field, Object logstashMarker) {
        try {
            return field.get(logstashMarker);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Nullable
    private static Field findValueField(Class<?> clazz, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        return null;
    }

    private static boolean supportsLogstashMarkers() {
        try {
            Class.forName("net.logstash.logback.marker.LogstashMarker");
            Class.forName("net.logstash.logback.marker.SingleFieldAppendingMarker");
            Class.forName("net.logstash.logback.marker.MapEntriesAppendingMarker");
            Class.forName("java.lang.ClassValue");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static boolean supportsLogstashStructuredArguments() {
        try {
            Class.forName("net.logstash.logback.argument.StructuredArgument");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @NoMuzzle
    private void captureLogstashStructuredArguments(LogRecordBuilder builder, Object[] arguments) {
        for (Object argument : arguments) {
            if (!LoggingEventMapper.isLogstashStructuredArgument(argument)) continue;
            this.captureLogstashStructuredArgument(builder, argument);
        }
    }

    @NoMuzzle
    private static boolean isLogstashStructuredArgument(Object argument) {
        return argument instanceof SingleFieldAppendingMarker;
    }

    @NoMuzzle
    private void captureLogstashStructuredArgument(LogRecordBuilder builder, Object argument) {
        SingleFieldAppendingMarker marker = (SingleFieldAppendingMarker)argument;
        this.captureLogstashMarker(builder, marker);
    }

    public static final class Builder {
        private boolean captureExperimentalAttributes;
        private List<String> captureMdcAttributes = Collections.emptyList();
        private boolean captureCodeAttributes;
        private boolean captureMarkerAttribute;
        private boolean captureKeyValuePairAttributes;
        private boolean captureLoggerContext;
        private boolean captureArguments;
        private boolean captureLogstashMarkerAttributes;
        private boolean captureLogstashStructuredArguments;
        private boolean captureEventName;

        Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setCaptureExperimentalAttributes(boolean captureExperimentalAttributes) {
            this.captureExperimentalAttributes = captureExperimentalAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureMdcAttributes(List<String> captureMdcAttributes) {
            this.captureMdcAttributes = captureMdcAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureCodeAttributes(boolean captureCodeAttributes) {
            this.captureCodeAttributes = captureCodeAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureMarkerAttribute(boolean captureMarkerAttribute) {
            this.captureMarkerAttribute = captureMarkerAttribute;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureKeyValuePairAttributes(boolean captureKeyValuePairAttributes) {
            this.captureKeyValuePairAttributes = captureKeyValuePairAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureLoggerContext(boolean captureLoggerContext) {
            this.captureLoggerContext = captureLoggerContext;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureArguments(boolean captureArguments) {
            this.captureArguments = captureArguments;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setCaptureLogstashAttributes(boolean captureLogstashAttributes) {
            return this.setCaptureLogstashMarkerAttributes(captureLogstashAttributes);
        }

        @CanIgnoreReturnValue
        public Builder setCaptureLogstashMarkerAttributes(boolean captureLogstashMarkerAttributes) {
            this.captureLogstashMarkerAttributes = captureLogstashMarkerAttributes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureLogstashStructuredArguments(boolean captureLogstashStructuredArguments) {
            this.captureLogstashStructuredArguments = captureLogstashStructuredArguments;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCaptureEventName(boolean captureEventName) {
            this.captureEventName = captureEventName;
            return this;
        }

        public LoggingEventMapper build() {
            return new LoggingEventMapper(this);
        }
    }

    private static interface FieldReader {
        public void read(LogRecordBuilder var1, Object var2, boolean var3);
    }

    private static class LogstashFieldReaderHolder {
        static final ClassValue<FieldReader> valueField = new ClassValue<FieldReader>(){

            @Override
            protected FieldReader computeValue(Class<?> type) {
                return LoggingEventMapper.createFieldReader(type);
            }
        };

        private LogstashFieldReaderHolder() {
        }
    }
}

