/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.appender.v1_0;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.logback.appender.v1_0.LoggingEventToReplay;
import io.opentelemetry.instrumentation.logback.appender.v1_0.internal.LoggingEventMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class OpenTelemetryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private boolean captureExperimentalAttributes = false;
    private boolean captureCodeAttributes = false;
    private boolean captureMarkerAttribute = false;
    private boolean captureKeyValuePairAttributes = false;
    private boolean captureLoggerContext = false;
    private List<String> captureMdcAttributes = Collections.emptyList();
    private volatile OpenTelemetry openTelemetry;
    private LoggingEventMapper mapper;
    private int numLogsCapturedBeforeOtelInstall = 1000;
    private BlockingQueue<LoggingEventToReplay> eventsToReplay = new ArrayBlockingQueue<LoggingEventToReplay>(this.numLogsCapturedBeforeOtelInstall);
    private final AtomicBoolean replayLimitWarningLogged = new AtomicBoolean();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public static void install(OpenTelemetry openTelemetry) {
        ILoggerFactory loggerFactorySpi = LoggerFactory.getILoggerFactory();
        if (!(loggerFactorySpi instanceof LoggerContext)) {
            return;
        }
        LoggerContext loggerContext = (LoggerContext)loggerFactorySpi;
        for (Logger logger : loggerContext.getLoggerList()) {
            logger.iteratorForAppenders().forEachRemaining(appender -> {
                if (appender instanceof OpenTelemetryAppender) {
                    ((OpenTelemetryAppender)((Object)appender)).setOpenTelemetry(openTelemetry);
                }
            });
        }
    }

    public void start() {
        this.mapper = LoggingEventMapper.builder().setCaptureExperimentalAttributes(this.captureExperimentalAttributes).setCaptureMdcAttributes(this.captureMdcAttributes).setCaptureCodeAttributes(this.captureCodeAttributes).setCaptureMarkerAttribute(this.captureMarkerAttribute).setCaptureKeyValuePairAttributes(this.captureKeyValuePairAttributes).setCaptureLoggerContext(this.captureLoggerContext).build();
        this.eventsToReplay = new ArrayBlockingQueue<LoggingEventToReplay>(this.numLogsCapturedBeforeOtelInstall);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent event) {
        OpenTelemetry openTelemetry = this.openTelemetry;
        if (openTelemetry != null) {
            this.emit(openTelemetry, event);
            return;
        }
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            openTelemetry = this.openTelemetry;
            if (openTelemetry != null) {
                this.emit(openTelemetry, event);
                return;
            }
            LoggingEventToReplay logEventToReplay = new LoggingEventToReplay(event, this.captureExperimentalAttributes, this.captureCodeAttributes);
            if (!this.eventsToReplay.offer(logEventToReplay) && !this.replayLimitWarningLogged.getAndSet(true)) {
                String message = "numLogsCapturedBeforeOtelInstall value of the OpenTelemetry appender is too small.";
                System.err.println(message);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    public void setCaptureExperimentalAttributes(boolean captureExperimentalAttributes) {
        this.captureExperimentalAttributes = captureExperimentalAttributes;
    }

    public void setCaptureCodeAttributes(boolean captureCodeAttributes) {
        this.captureCodeAttributes = captureCodeAttributes;
    }

    public void setCaptureMarkerAttribute(boolean captureMarkerAttribute) {
        this.captureMarkerAttribute = captureMarkerAttribute;
    }

    public void setCaptureKeyValuePairAttributes(boolean captureKeyValuePairAttributes) {
        this.captureKeyValuePairAttributes = captureKeyValuePairAttributes;
    }

    public void setCaptureLoggerContext(boolean captureLoggerContext) {
        this.captureLoggerContext = captureLoggerContext;
    }

    public void setCaptureMdcAttributes(String attributes) {
        this.captureMdcAttributes = attributes != null ? OpenTelemetryAppender.filterBlanksAndNulls(attributes.split(",")) : Collections.emptyList();
    }

    public void setNumLogsCapturedBeforeOtelInstall(int size) {
        this.numLogsCapturedBeforeOtelInstall = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOpenTelemetry(OpenTelemetry openTelemetry) {
        ArrayList eventsToReplay = new ArrayList();
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.openTelemetry = openTelemetry;
            this.eventsToReplay.drainTo(eventsToReplay);
        }
        finally {
            writeLock.unlock();
        }
        for (LoggingEventToReplay eventToReplay : eventsToReplay) {
            this.emit(openTelemetry, eventToReplay);
        }
    }

    private void emit(OpenTelemetry openTelemetry, ILoggingEvent event) {
        this.mapper.emit(openTelemetry.getLogsBridge(), event, -1L);
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

