/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.mdc.v1_0;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.logback.mdc.v1_0.internal.UnionMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;

public class OpenTelemetryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private boolean addBaggage;
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();

    public void setAddBaggage(boolean addBaggage) {
        this.addBaggage = addBaggage;
    }

    public ILoggingEvent wrapEvent(ILoggingEvent event) {
        AbstractMap eventContext = event.getMDCPropertyMap();
        if (eventContext != null && eventContext.containsKey("trace_id")) {
            return event;
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        Context context = Context.current();
        Span currentSpan = Span.fromContext((Context)context);
        if (currentSpan.getSpanContext().isValid()) {
            SpanContext spanContext = currentSpan.getSpanContext();
            contextData.put("trace_id", spanContext.getTraceId());
            contextData.put("span_id", spanContext.getSpanId());
            contextData.put("trace_flags", spanContext.getTraceFlags().asHex());
        }
        if (this.addBaggage) {
            Baggage baggage = Baggage.fromContext((Context)context);
            baggage.forEach((key, value) -> contextData.put("baggage." + key, value.getValue()));
        }
        eventContext = eventContext == null ? contextData : new UnionMap(eventContext, contextData);
        HashMap<String, String> eventContextMap = eventContext;
        LoggerContextVO oldVo = event.getLoggerContextVO();
        LoggerContextVO vo = oldVo != null ? new LoggerContextVO(oldVo.getName(), eventContextMap, oldVo.getBirthTime()) : null;
        return (ILoggingEvent)Proxy.newProxyInstance(ILoggingEvent.class.getClassLoader(), new Class[]{ILoggingEvent.class}, (proxy, method, args) -> {
            if ("getMDCPropertyMap".equals(method.getName())) {
                return eventContextMap;
            }
            if ("getLoggerContextVO".equals(method.getName())) {
                return vo;
            }
            try {
                return method.invoke((Object)event, args);
            }
            catch (InvocationTargetException exception) {
                throw exception.getCause();
            }
        });
    }

    protected void append(ILoggingEvent event) {
        this.aai.appendLoopOnAppenders((Object)this.wrapEvent(event));
    }

    public void addAppender(Appender<ILoggingEvent> appender) {
        this.aai.addAppender(appender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }
}

