/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.logback.mdc.v1_0;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.logback.mdc.v1_0.internal.UnionMap;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;

public class OpenTelemetryAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final Field MDC_MAP_FIELD;
    private boolean addBaggage;
    private String traceIdKey = "trace_id";
    private String spanIdKey = "span_id";
    private String traceFlagsKey = "trace_flags";
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();

    public void setAddBaggage(boolean addBaggage) {
        this.addBaggage = addBaggage;
    }

    public void setTraceIdKey(String traceIdKey) {
        this.traceIdKey = traceIdKey;
    }

    public void setSpanIdKey(String spanIdKey) {
        this.spanIdKey = spanIdKey;
    }

    public void setTraceFlagsKey(String traceFlagsKey) {
        this.traceFlagsKey = traceFlagsKey;
    }

    private void processEvent(ILoggingEvent event) {
        if (MDC_MAP_FIELD == null || event.getClass() != LoggingEvent.class) {
            return;
        }
        AbstractMap eventContext = event.getMDCPropertyMap();
        if (eventContext != null && eventContext.containsKey(this.traceIdKey)) {
            return;
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        Context context = Context.current();
        Span currentSpan = Span.fromContext((Context)context);
        if (currentSpan.getSpanContext().isValid()) {
            SpanContext spanContext = currentSpan.getSpanContext();
            contextData.put(this.traceIdKey, spanContext.getTraceId());
            contextData.put(this.spanIdKey, spanContext.getSpanId());
            contextData.put(this.traceFlagsKey, spanContext.getTraceFlags().asHex());
        }
        if (this.addBaggage) {
            Baggage baggage = Baggage.fromContext((Context)context);
            baggage.forEach((key, value) -> contextData.put("baggage." + key, value.getValue()));
        }
        eventContext = eventContext == null ? contextData : new UnionMap(eventContext, contextData);
        HashMap<String, String> eventContextMap = eventContext;
        LoggerContextVO oldVo = event.getLoggerContextVO();
        LoggerContextVO vo = oldVo != null ? new LoggerContextVO(oldVo.getName(), eventContextMap, oldVo.getBirthTime()) : null;
        try {
            MDC_MAP_FIELD.set(event, eventContextMap);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ((LoggingEvent)event).setLoggerContextRemoteView(vo);
    }

    protected void append(ILoggingEvent event) {
        this.processEvent(event);
        this.aai.appendLoopOnAppenders((Object)event);
    }

    public void addAppender(Appender<ILoggingEvent> appender) {
        this.aai.addAppender(appender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    static {
        Field field;
        try {
            field = LoggingEvent.class.getDeclaredField("mdcPropertyMap");
            field.setAccessible(true);
        }
        catch (Exception exception) {
            field = null;
        }
        MDC_MAP_FIELD = field;
    }
}

