/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeterRegistry;
import io.opentelemetry.instrumentation.micrometer.v1_5.PrometheusModeNamingConvention;
import java.util.concurrent.TimeUnit;

public final class OpenTelemetryMeterRegistryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.micrometer-1.5";
    private final OpenTelemetry openTelemetry;
    private Clock clock = Clock.SYSTEM;
    private TimeUnit baseTimeUnit = TimeUnit.MILLISECONDS;
    private boolean prometheusMode = false;

    OpenTelemetryMeterRegistryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setBaseTimeUnit(TimeUnit baseTimeUnit) {
        this.baseTimeUnit = baseTimeUnit;
        return this;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setPrometheusMode(boolean prometheusMode) {
        this.prometheusMode = prometheusMode;
        return this;
    }

    public MeterRegistry build() {
        TimeUnit baseTimeUnit = this.prometheusMode ? TimeUnit.SECONDS : this.baseTimeUnit;
        PrometheusModeNamingConvention namingConvention = this.prometheusMode ? PrometheusModeNamingConvention.INSTANCE : NamingConvention.identity;
        return new OpenTelemetryMeterRegistry(this.clock, baseTimeUnit, namingConvention, this.openTelemetry.getMeterProvider().get(INSTRUMENTATION_NAME));
    }
}

