/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.NoopHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.instrumentation.micrometer.v1_5.Bridging;
import io.opentelemetry.instrumentation.micrometer.v1_5.DoubleMeasurementRecorder;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger;
import java.util.Collections;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

final class OpenTelemetryDistributionSummary
extends AbstractDistributionSummary
implements RemovableMeter {
    private final Measurements measurements = this.isUsingMicrometerHistograms() ? new MicrometerHistogramMeasurements() : NoopMeasurements.INSTANCE;
    private final TimeWindowMax max;
    private final DoubleHistogram otelHistogram;
    private final Attributes attributes;
    private final ObservableDoubleGauge observableMax;
    private volatile boolean removed = false;

    OpenTelemetryDistributionSummary(Meter.Id id, NamingConvention namingConvention, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, Meter otelMeter) {
        super(id, clock, distributionStatisticConfig, scale, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.attributes = Bridging.tagsAsAttributes(id, namingConvention);
        String name = Bridging.name(id, namingConvention);
        this.otelHistogram = otelMeter.histogramBuilder(name).setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).build();
        this.observableMax = otelMeter.gaugeBuilder(name + ".max").setDescription(Bridging.description(id)).setUnit(Bridging.baseUnit(id)).buildWithCallback(new DoubleMeasurementRecorder<TimeWindowMax>(this.max, TimeWindowMax::poll, this.attributes));
    }

    boolean isUsingMicrometerHistograms() {
        return this.histogram != NoopHistogram.INSTANCE;
    }

    protected void recordNonNegative(double amount) {
        if (!this.removed) {
            this.otelHistogram.record(amount, this.attributes);
            this.measurements.record(amount);
            this.max.record(amount);
        }
    }

    public long count() {
        return this.measurements.count();
    }

    public double totalAmount() {
        return this.measurements.totalAmount();
    }

    public double max() {
        return this.max.poll();
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.removed = true;
        this.observableMax.close();
    }

    private static final class MicrometerHistogramMeasurements
    implements Measurements {
        private final LongAdder count = new LongAdder();
        private final DoubleAdder totalAmount = new DoubleAdder();

        private MicrometerHistogramMeasurements() {
        }

        @Override
        public void record(double amount) {
            this.count.increment();
            this.totalAmount.add(amount);
        }

        @Override
        public long count() {
            return this.count.sum();
        }

        @Override
        public double totalAmount() {
            return this.totalAmount.sum();
        }
    }

    private static interface Measurements {
        public void record(double var1);

        public long count();

        public double totalAmount();
    }

    static enum NoopMeasurements implements Measurements
    {
        INSTANCE;


        @Override
        public void record(double amount) {
        }

        @Override
        public long count() {
            UnsupportedReadLogger.logWarning();
            return 0L;
        }

        @Override
        public double totalAmount() {
            UnsupportedReadLogger.logWarning();
            return Double.NaN;
        }
    }
}

