/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.NoopHistogram;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.instrumentation.micrometer.v1_5.Bridging;
import io.opentelemetry.instrumentation.micrometer.v1_5.DoubleMeasurementRecorder;
import io.opentelemetry.instrumentation.micrometer.v1_5.RemovableMeter;
import io.opentelemetry.instrumentation.micrometer.v1_5.TimeUnitHelper;
import io.opentelemetry.instrumentation.micrometer.v1_5.UnsupportedReadLogger;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

final class OpenTelemetryTimer
extends AbstractTimer
implements RemovableMeter {
    private final Measurements measurements = this.isUsingMicrometerHistograms() ? new MicrometerHistogramMeasurements() : NoopMeasurements.INSTANCE;
    private final TimeWindowMax max;
    private final TimeUnit baseTimeUnit;
    private final DoubleHistogram otelHistogram;
    private final Attributes attributes;
    private final ObservableDoubleGauge observableMax;
    private volatile boolean removed = false;

    OpenTelemetryTimer(Meter.Id id, NamingConvention namingConvention, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, Meter otelMeter) {
        super(id, clock, distributionStatisticConfig, pauseDetector, TimeUnit.MILLISECONDS, false);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.baseTimeUnit = baseTimeUnit;
        this.attributes = Bridging.tagsAsAttributes(id, namingConvention);
        String name = Bridging.name(id, namingConvention);
        this.otelHistogram = otelMeter.histogramBuilder(name).setDescription(Bridging.description(id)).setUnit(TimeUnitHelper.getUnitString(baseTimeUnit)).build();
        this.observableMax = otelMeter.gaugeBuilder(name + ".max").setDescription(Bridging.description(id)).setUnit(TimeUnitHelper.getUnitString(baseTimeUnit)).buildWithCallback(new DoubleMeasurementRecorder<TimeWindowMax>(this.max, m -> m.poll(baseTimeUnit), this.attributes));
    }

    boolean isUsingMicrometerHistograms() {
        return this.histogram != NoopHistogram.INSTANCE;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        if (!this.removed) {
            double nanos = unit.toNanos(amount);
            double time = TimeUtils.nanosToUnit((double)nanos, (TimeUnit)this.baseTimeUnit);
            this.otelHistogram.record(time, this.attributes);
            this.measurements.record(nanos);
            this.max.record(nanos, TimeUnit.NANOSECONDS);
        }
    }

    public long count() {
        return this.measurements.count();
    }

    public double totalTime(TimeUnit unit) {
        return this.measurements.totalTime(unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public Iterable<Measurement> measure() {
        UnsupportedReadLogger.logWarning();
        return Collections.emptyList();
    }

    @Override
    public void onRemove() {
        this.removed = true;
        this.observableMax.close();
    }

    private static final class MicrometerHistogramMeasurements
    implements Measurements {
        private final LongAdder count = new LongAdder();
        private final DoubleAdder totalTime = new DoubleAdder();

        private MicrometerHistogramMeasurements() {
        }

        @Override
        public void record(double nanos) {
            this.count.increment();
            this.totalTime.add(nanos);
        }

        @Override
        public long count() {
            return this.count.sum();
        }

        @Override
        public double totalTime(TimeUnit unit) {
            return TimeUtils.nanosToUnit((double)this.totalTime.sum(), (TimeUnit)unit);
        }
    }

    private static interface Measurements {
        public void record(double var1);

        public long count();

        public double totalTime(TimeUnit var1);
    }

    static enum NoopMeasurements implements Measurements
    {
        INSTANCE;


        @Override
        public void record(double nanos) {
        }

        @Override
        public long count() {
            UnsupportedReadLogger.logWarning();
            return 0L;
        }

        @Override
        public double totalTime(TimeUnit unit) {
            UnsupportedReadLogger.logWarning();
            return Double.NaN;
        }
    }
}

