/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.util.TimeUtils;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.extension.incubator.metrics.ExtendedDoubleHistogramBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class HistogramAdviceUtil {
    static void setExplicitBucketsIfConfigured(DoubleHistogramBuilder builder, DistributionStatisticConfig config) {
        HistogramAdviceUtil.setExplicitBucketsIfConfigured(builder, config, null);
    }

    static void setExplicitBucketsIfConfigured(DoubleHistogramBuilder builder, DistributionStatisticConfig config, @Nullable TimeUnit timeUnit) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        NavigableSet buckets = config.getHistogramBuckets(false);
        ExtendedDoubleHistogramBuilder extendedBuilder = (ExtendedDoubleHistogramBuilder)builder;
        extendedBuilder.setExplicitBucketBoundariesAdvice(HistogramAdviceUtil.computeBuckets(buckets, timeUnit));
    }

    private static List<Double> computeBuckets(NavigableSet<Double> buckets, @Nullable TimeUnit timeUnit) {
        if (buckets.isEmpty()) {
            return Collections.emptyList();
        }
        double timeUnitMultiplier = timeUnit == null ? 1.0 : TimeUtils.nanosToUnit((double)1.0, (TimeUnit)timeUnit);
        ArrayList<Double> result = new ArrayList<Double>(buckets.size());
        for (double b : buckets) {
            result.add(b * timeUnitMultiplier);
        }
        return result;
    }

    private HistogramAdviceUtil() {
    }
}

