/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.mongo.v3_1;

import com.mongodb.event.CommandStartedEvent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoAttributesExtractor;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoDbAttributesGetter;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoNetworkAttributesGetter;
import io.opentelemetry.instrumentation.mongo.v3_1.MongoSpanNameExtractor;

class MongoInstrumenterFactory {
    private static final MongoAttributesExtractor attributesExtractor = new MongoAttributesExtractor();

    static Instrumenter<CommandStartedEvent, Void> createInstrumenter(OpenTelemetry openTelemetry, boolean statementSanitizationEnabled, int maxNormalizedQueryLength) {
        MongoDbAttributesGetter dbAttributesGetter = new MongoDbAttributesGetter(statementSanitizationEnabled, maxNormalizedQueryLength);
        MongoSpanNameExtractor spanNameExtractor = new MongoSpanNameExtractor(dbAttributesGetter, attributesExtractor);
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.opentelemetry.mongo-3.1", (SpanNameExtractor)spanNameExtractor).addAttributesExtractor(DbClientAttributesExtractor.create((DbClientAttributesGetter)dbAttributesGetter)).addAttributesExtractor((AttributesExtractor)ServerAttributesExtractor.create((ServerAttributesGetter)new MongoNetworkAttributesGetter())).addAttributesExtractor((AttributesExtractor)attributesExtractor).buildInstrumenter(SpanKindExtractor.alwaysClient());
    }

    private MongoInstrumenterFactory() {
    }
}

