/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.mongo.v3_1;

import com.mongodb.event.CommandStartedEvent;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.bson.BsonValue;

class MongoAttributesExtractor
implements AttributesExtractor<CommandStartedEvent, Void> {
    private static final Set<String> COMMANDS_WITH_COLLECTION_NAME_AS_VALUE = new HashSet<String>(Arrays.asList("aggregate", "count", "distinct", "mapReduce", "geoSearch", "delete", "find", "killCursors", "findAndModify", "insert", "update", "create", "drop", "createIndexes", "listIndexes"));

    MongoAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, CommandStartedEvent event) {
        String collectionName = this.collectionName(event);
        if (collectionName != null) {
            attributes.put(DbIncubatingAttributes.DB_MONGODB_COLLECTION, (Object)collectionName);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, CommandStartedEvent event, @Nullable Void unused, @Nullable Throwable error) {
    }

    @Nullable
    String collectionName(CommandStartedEvent event) {
        BsonValue commandValue;
        if (event.getCommandName().equals("getMore")) {
            BsonValue collectionValue = event.getCommand().get((Object)"collection");
            if (collectionValue != null && collectionValue.isString()) {
                return collectionValue.asString().getValue();
            }
        } else if (COMMANDS_WITH_COLLECTION_NAME_AS_VALUE.contains(event.getCommandName()) && (commandValue = event.getCommand().get((Object)event.getCommandName())) != null && commandValue.isString()) {
            return commandValue.asString().getValue();
        }
        return null;
    }
}

