/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.netty.common.internal.NettyConnectionRequest;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumenter;

public class ConnectionCompleteListener
implements GenericFutureListener<Future<Void>> {
    private final NettyConnectionInstrumenter instrumenter;
    private final Context context;
    private final NettyConnectionRequest request;

    public ConnectionCompleteListener(NettyConnectionInstrumenter instrumenter, Context context, NettyConnectionRequest request) {
        this.instrumenter = instrumenter;
        this.context = context;
        this.request = request;
    }

    public void operationComplete(Future<Void> future) {
        Channel channel = null;
        if (future instanceof ChannelFuture) {
            channel = ((ChannelFuture)future).channel();
        }
        this.instrumenter.end(this.context, this.request, channel, future.cause());
    }
}

