/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.netty.common.internal.NettyConnectionRequest;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.HttpRequestHeadersSetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectHttpAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumentationFlag;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumenterImpl;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyErrorOnlyConnectionInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyHttpClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslErrorOnlyInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslInstrumenterImpl;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslNetAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslRequest;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NoopConnectionInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NoopSslInstrumenter;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class NettyClientInstrumenterFactory {
    private final OpenTelemetry openTelemetry;
    private final String instrumentationName;
    private final NettyConnectionInstrumentationFlag connectionTelemetryState;
    private final NettyConnectionInstrumentationFlag sslTelemetryState;
    private final Map<String, String> peerServiceMapping;
    private final boolean emitExperimentalHttpClientMetrics;

    public NettyClientInstrumenterFactory(OpenTelemetry openTelemetry, String instrumentationName, NettyConnectionInstrumentationFlag connectionTelemetryState, NettyConnectionInstrumentationFlag sslTelemetryState, Map<String, String> peerServiceMapping, boolean emitExperimentalHttpClientMetrics) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
        this.connectionTelemetryState = connectionTelemetryState;
        this.sslTelemetryState = sslTelemetryState;
        this.peerServiceMapping = peerServiceMapping;
        this.emitExperimentalHttpClientMetrics = emitExperimentalHttpClientMetrics;
    }

    public Instrumenter<HttpRequestAndChannel, HttpResponse> createHttpInstrumenter(Consumer<HttpClientAttributesExtractorBuilder<HttpRequestAndChannel, HttpResponse>> extractorConfigurer, List<AttributesExtractor<HttpRequestAndChannel, HttpResponse>> additionalHttpAttributeExtractors) {
        NettyHttpClientAttributesGetter httpAttributesGetter = new NettyHttpClientAttributesGetter();
        HttpClientAttributesExtractorBuilder extractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter);
        extractorConfigurer.accept((HttpClientAttributesExtractorBuilder<HttpRequestAndChannel, HttpResponse>)extractorBuilder);
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(extractorBuilder.build()).addAttributesExtractor(PeerServiceAttributesExtractor.create((ServerAttributesGetter)httpAttributesGetter, this.peerServiceMapping)).addAttributesExtractors(additionalHttpAttributeExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.emitExperimentalHttpClientMetrics) {
            builder.addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        return builder.buildClientInstrumenter((TextMapSetter)HttpRequestHeadersSetter.INSTANCE);
    }

    public NettyConnectionInstrumenter createConnectionInstrumenter() {
        if (this.connectionTelemetryState == NettyConnectionInstrumentationFlag.DISABLED) {
            return NoopConnectionInstrumenter.INSTANCE;
        }
        boolean connectionTelemetryFullyEnabled = this.connectionTelemetryState == NettyConnectionInstrumentationFlag.ENABLED;
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, NettyConnectionRequest::spanName).addAttributesExtractor(PeerServiceAttributesExtractor.create((ServerAttributesGetter)NettyConnectHttpAttributesGetter.INSTANCE, this.peerServiceMapping)).addAttributesExtractor(HttpClientAttributesExtractor.create((HttpClientAttributesGetter)NettyConnectHttpAttributesGetter.INSTANCE)).buildInstrumenter(connectionTelemetryFullyEnabled ? SpanKindExtractor.alwaysInternal() : SpanKindExtractor.alwaysClient());
        return connectionTelemetryFullyEnabled ? new NettyConnectionInstrumenterImpl((Instrumenter<NettyConnectionRequest, Channel>)instrumenter) : new NettyErrorOnlyConnectionInstrumenter((Instrumenter<NettyConnectionRequest, Channel>)instrumenter);
    }

    public NettySslInstrumenter createSslInstrumenter() {
        if (this.sslTelemetryState == NettyConnectionInstrumentationFlag.DISABLED) {
            return NoopSslInstrumenter.INSTANCE;
        }
        boolean sslTelemetryFullyEnabled = this.sslTelemetryState == NettyConnectionInstrumentationFlag.ENABLED;
        NettySslNetAttributesGetter netAttributesGetter = new NettySslNetAttributesGetter();
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, NettySslRequest::spanName).addAttributesExtractor(NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).addAttributesExtractor(PeerServiceAttributesExtractor.create((ServerAttributesGetter)netAttributesGetter, this.peerServiceMapping)).buildInstrumenter(sslTelemetryFullyEnabled ? SpanKindExtractor.alwaysInternal() : SpanKindExtractor.alwaysClient());
        return sslTelemetryFullyEnabled ? new NettySslInstrumenterImpl((Instrumenter<NettySslRequest, Void>)instrumenter) : new NettySslErrorOnlyInstrumenter((Instrumenter<NettySslRequest, Void>)instrumenter);
    }
}

