/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.common.internal.NettyConnectionRequest;
import io.opentelemetry.instrumentation.netty.v4.common.internal.ChannelUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

enum NettyConnectHttpAttributesGetter implements HttpClientAttributesGetter<NettyConnectionRequest, Channel>
{
    INSTANCE;


    @Nullable
    public String getUrlFull(NettyConnectionRequest nettyConnectionRequest) {
        return null;
    }

    @Nullable
    public String getHttpRequestMethod(NettyConnectionRequest nettyConnectionRequest) {
        return null;
    }

    public List<String> getHttpRequestHeader(NettyConnectionRequest nettyConnectionRequest, String name) {
        return Collections.emptyList();
    }

    @Nullable
    public Integer getHttpResponseStatusCode(NettyConnectionRequest nettyConnectionRequest, Channel channel, @Nullable Throwable error) {
        return null;
    }

    public List<String> getHttpResponseHeader(NettyConnectionRequest nettyConnectionRequest, Channel channel, String name) {
        return Collections.emptyList();
    }

    public String getTransport(NettyConnectionRequest request, @Nullable Channel channel) {
        return channel instanceof DatagramChannel ? "ip_udp" : "ip_tcp";
    }

    public String getNetworkTransport(NettyConnectionRequest request, @Nullable Channel channel) {
        return ChannelUtil.getNetworkTransport(channel);
    }

    @Nullable
    public String getServerAddress(NettyConnectionRequest request) {
        SocketAddress requestedAddress = request.remoteAddressOnStart();
        if (requestedAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)requestedAddress).getHostString();
        }
        return null;
    }

    @Nullable
    public Integer getServerPort(NettyConnectionRequest request) {
        SocketAddress requestedAddress = request.remoteAddressOnStart();
        if (requestedAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)requestedAddress).getPort();
        }
        return null;
    }

    @Nullable
    public InetSocketAddress getServerInetSocketAddress(NettyConnectionRequest request, @Nullable Channel channel) {
        if (channel == null) {
            return null;
        }
        SocketAddress remoteAddress = channel.remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)remoteAddress;
        }
        return null;
    }
}

