/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.ChannelUtil;
import io.opentelemetry.instrumentation.netty.v4.common.internal.HttpSchemeUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;

final class NettyHttpClientAttributesGetter
implements HttpClientAttributesGetter<HttpRequestAndChannel, HttpResponse> {
    NettyHttpClientAttributesGetter() {
    }

    @Nullable
    public String getUrlFull(HttpRequestAndChannel requestAndChannel) {
        try {
            String hostHeader = this.getHost(requestAndChannel);
            String target = requestAndChannel.request().getUri();
            URI uri = new URI(target);
            if ((uri.getHost() == null || uri.getHost().equals("")) && hostHeader != null) {
                return HttpSchemeUtil.getScheme(requestAndChannel) + "://" + hostHeader + target;
            }
            return uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getHost(HttpRequestAndChannel requestAndChannel) {
        List<String> values = this.getHttpRequestHeader(requestAndChannel, "host");
        return values.isEmpty() ? null : values.get(0);
    }

    public String getHttpRequestMethod(HttpRequestAndChannel requestAndChannel) {
        return requestAndChannel.request().getMethod().name();
    }

    public List<String> getHttpRequestHeader(HttpRequestAndChannel requestAndChannel, String name) {
        return requestAndChannel.request().headers().getAll(name);
    }

    public Integer getHttpResponseStatusCode(HttpRequestAndChannel requestAndChannel, HttpResponse response, @Nullable Throwable error) {
        return response.getStatus().code();
    }

    public List<String> getHttpResponseHeader(HttpRequestAndChannel requestAndChannel, HttpResponse response, String name) {
        return response.headers().getAll(name);
    }

    public String getTransport(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        return requestAndChannel.channel() instanceof DatagramChannel ? "ip_udp" : "ip_tcp";
    }

    public String getNetworkTransport(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        return ChannelUtil.getNetworkTransport(requestAndChannel.channel());
    }

    public String getNetworkProtocolName(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        return requestAndChannel.request().getProtocolVersion().protocolName();
    }

    public String getNetworkProtocolVersion(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        HttpVersion version = requestAndChannel.request().getProtocolVersion();
        if (version.minorVersion() == 0) {
            return Integer.toString(version.majorVersion());
        }
        return version.majorVersion() + "." + version.minorVersion();
    }

    @Nullable
    public String getServerAddress(HttpRequestAndChannel requestAndChannel) {
        return null;
    }

    @Nullable
    public Integer getServerPort(HttpRequestAndChannel requestAndChannel) {
        return null;
    }

    @Nullable
    public InetSocketAddress getServerInetSocketAddress(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        SocketAddress address = requestAndChannel.remoteAddress();
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }
}

