/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.server;

import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.ChannelUtil;
import io.opentelemetry.instrumentation.netty.v4.common.internal.HttpSchemeUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import javax.annotation.Nullable;

final class NettyHttpServerAttributesGetter
implements HttpServerAttributesGetter<HttpRequestAndChannel, HttpResponse> {
    NettyHttpServerAttributesGetter() {
    }

    public String getHttpRequestMethod(HttpRequestAndChannel requestAndChannel) {
        return requestAndChannel.request().getMethod().name();
    }

    public List<String> getHttpRequestHeader(HttpRequestAndChannel requestAndChannel, String name) {
        return requestAndChannel.request().headers().getAll(name);
    }

    public Integer getHttpResponseStatusCode(HttpRequestAndChannel requestAndChannel, HttpResponse response, @Nullable Throwable error) {
        return response.getStatus().code();
    }

    public List<String> getHttpResponseHeader(HttpRequestAndChannel requestAndChannel, HttpResponse response, String name) {
        return response.headers().getAll(name);
    }

    public String getUrlScheme(HttpRequestAndChannel requestAndChannel) {
        return HttpSchemeUtil.getScheme(requestAndChannel);
    }

    public String getUrlPath(HttpRequestAndChannel requestAndChannel) {
        String fullPath = requestAndChannel.request().getUri();
        int separatorPos = fullPath.indexOf(63);
        return separatorPos == -1 ? fullPath : fullPath.substring(0, separatorPos);
    }

    public String getUrlQuery(HttpRequestAndChannel requestAndChannel) {
        String fullPath = requestAndChannel.request().getUri();
        int separatorPos = fullPath.indexOf(63);
        return separatorPos == -1 ? null : fullPath.substring(separatorPos + 1);
    }

    public String getTransport(HttpRequestAndChannel requestAndChannel) {
        return requestAndChannel.channel() instanceof DatagramChannel ? "ip_udp" : "ip_tcp";
    }

    public String getNetworkTransport(HttpRequestAndChannel requestAndChannel, HttpResponse response) {
        return ChannelUtil.getNetworkTransport(requestAndChannel.channel());
    }

    public String getNetworkProtocolName(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        return requestAndChannel.request().getProtocolVersion().protocolName();
    }

    public String getNetworkProtocolVersion(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        HttpVersion version = requestAndChannel.request().getProtocolVersion();
        if (version.minorVersion() == 0) {
            return Integer.toString(version.majorVersion());
        }
        return version.majorVersion() + "." + version.minorVersion();
    }

    @Nullable
    public String getServerAddress(HttpRequestAndChannel requestAndChannel) {
        return null;
    }

    @Nullable
    public Integer getServerPort(HttpRequestAndChannel requestAndChannel) {
        return null;
    }

    @Nullable
    public InetSocketAddress getClientInetSocketAddress(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        SocketAddress address = requestAndChannel.remoteAddress();
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }

    @Nullable
    public InetSocketAddress getServerInetSocketAddress(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        SocketAddress address = requestAndChannel.channel().localAddress();
        if (address instanceof InetSocketAddress) {
            return (InetSocketAddress)address;
        }
        return null;
    }
}

